/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core.client;

import com.atlassian.connector.commons.api.BambooServerFacade2;
import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.core.PlanBranches;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClientData;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooRemoteOperation;
import com.atlassian.connector.eclipse.internal.core.client.AbstractConnectorClient;
import com.atlassian.connector.eclipse.internal.core.client.HttpSessionCallbackImpl;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.api.BambooSession;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.ProductServerFacade;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooClient
extends AbstractConnectorClient<BambooServerFacade2, BambooSession> {
    private BambooClientData clientData;

    public BambooClient(AbstractWebLocation location, ConnectionCfg serverCfg, BambooServerFacade2 server, BambooClientData data, HttpSessionCallbackImpl callback) {
        super(location, serverCfg, (ProductServerFacade)server, callback);
        this.clientData = data;
    }

    public boolean hasRepositoryData() {
        return this.clientData != null && this.clientData.hasData();
    }

    public BambooClientData getClientData() {
        return this.clientData;
    }

    public BambooClientData updateRepositoryData(IProgressMonitor monitor, TaskRepository taskRepository) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("updateRepositoryData", null);
        this.clientData = (BambooClientData)this.execute(new BambooRemoteOperation<BambooClientData>(monitor, taskRepository){

            public BambooClientData run(BambooServerFacade2 server, ConnectionCfg connectionCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Retrieving plans");
                BambooClientData newClientData = new BambooClientData();
                Collection projects = server.getPlanList(connectionCfg);
                newClientData.setPlans(projects);
                return newClientData;
            }
        });
        return this.clientData;
    }

    public Collection<BambooBuild> getBuilds(IProgressMonitor monitor, final TaskRepository taskRepository, boolean promptForCredentials) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("getBuilds", null);
        return (Collection)this.execute(new BambooRemoteOperation<Collection<BambooBuild>>(monitor, taskRepository){

            public Collection<BambooBuild> run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Retrieving builds");
                return server.getSubscribedPlansResults(serverCfg, BambooUtil.getSubscribedPlans(taskRepository), BambooUtil.isUseFavourites(taskRepository), !BambooUtil.getPlanBranches(taskRepository).equals((Object)PlanBranches.NO), BambooUtil.getPlanBranches(taskRepository).equals((Object)PlanBranches.MINE), 0);
            }
        }, promptForCredentials);
    }

    public BuildDetails getBuildDetails(IProgressMonitor monitor, TaskRepository taskRepository, final BambooBuild build) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("getBuildDetails", null);
        return (BuildDetails)this.execute(new BambooRemoteOperation<BuildDetails>(monitor, taskRepository){

            public BuildDetails run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Retrieving build details");
                BuildDetails buildDetails = server.getBuildDetails(serverCfg, build.getPlanKey(), build.getNumber());
                return buildDetails;
            }
        });
    }

    public String getBuildLogs(IProgressMonitor monitor, TaskRepository taskRepository, final BambooBuild build) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("getBuildLogs", null);
        return (String)this.execute(new BambooRemoteOperation<String>(monitor, taskRepository){

            public String run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Retrieving build details");
                return server.getBuildLogs(serverCfg, build.getPlanKey(), build.getNumber());
            }
        });
    }

    public void addLabelToBuild(IProgressMonitor monitor, TaskRepository repository, final BambooBuild build, final String label) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("addLabelToBuild", null);
        this.execute(new BambooRemoteOperation<Object>(monitor, repository){

            public Object run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Adding label to build");
                server.addLabelToBuild(serverCfg, build.getPlanKey(), build.getNumber(), label);
                return null;
            }
        });
    }

    public void addCommentToBuild(IProgressMonitor monitor, TaskRepository repository, final BambooBuild build, final String comment) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("addCommentToBuild", null);
        this.execute(new BambooRemoteOperation<Object>(monitor, repository){

            public Object run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Adding comment to build");
                server.addCommentToBuild(serverCfg, build.getPlanKey(), build.getNumber(), comment);
                return null;
            }
        });
    }

    public void runBuild(IProgressMonitor monitor, TaskRepository repository, final BambooBuild build) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("runBuild", null);
        this.execute(new BambooRemoteOperation<Object>(monitor, repository){

            public Object run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Run Build");
                server.executeBuild(serverCfg, build.getPlanKey());
                return null;
            }
        });
    }

    public BambooBuild getBuildForPlanAndNumber(IProgressMonitor monitor, TaskRepository repository, final String planKey, final int buildNumber, final int timezoneOffset) throws CoreException {
        BambooCorePlugin.getMonitoring().logJob("getBuildForPlanAndNumber", null);
        return (BambooBuild)this.execute(new BambooRemoteOperation<BambooBuild>(monitor, repository){

            public BambooBuild run(BambooServerFacade2 server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws RemoteApiException, ServerPasswordNotProvidedException {
                monitor.subTask("Retrieving build details");
                return server.getBuildForPlanAndNumber(serverCfg, planKey, buildNumber, timezoneOffset);
            }
        });
    }

    protected BambooSession getSession(ConnectionCfg connectionCfg) throws RemoteApiException, ServerPasswordNotProvidedException {
        return ((BambooServerFacade2)this.facade).getSession(connectionCfg);
    }
}

