/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class GlobalPreferenceEnhancer {
    private static final String JDT_UI_BUNDLE_ID = "org.eclipse.jdt.ui";
    private static final String CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVA = "content_assist_autoactivation_triggers_java";
    private static final String CODEASSIST_AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String EDITOR_ESCAPE_STRINGS = "escape\u00a5Strings";
    private static final String EDITOR_SMART_PASTE = "smartPaste";
    private static final String EDITOR_SMART_TAB = "smart_tab";
    private static final String EDITOR_SMART_BACKSPACE = "smart_backspace";
    private static final String EDITOR_SMART_OPENING_BRACE = "smart_opening_brace";
    private static final String EDITOR_SMART_SEMICOLON = "smart_semicolon";
    private static final String M2E_CORE_BUNDLE_ID = "org.eclipse.m2e.core";
    private static final String P_HIDE_FOLDERS_OF_NESTED_PROJECTS = "eclipse.m2.hideFoldersOfNestedProjects";
    private static final String P_DEFAULT_POM_EDITOR_PAGE = "eclipse.m2.defaultPomEditorPage";
    private static final String P_UPDATE_INDEXES = "eclipse.m2.updateIndexes";
    private static final String JDT_CORE_BUNDLE_ID = "org.eclipse.jdt.core";
    private static final String COMPILER_PB_NON_NLS_STRING_LITERAL = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";

    public void enhanceAllPreferences() {
        this.enhanceM2EPreferences();
        this.enhanceJDTPreferences();
    }

    public void enhanceM2EPreferences() {
        IEclipsePreferences m2eCorePrefs = InstanceScope.INSTANCE.getNode(M2E_CORE_BUNDLE_ID);
        if (m2eCorePrefs != null) {
            m2eCorePrefs.putBoolean(P_HIDE_FOLDERS_OF_NESTED_PROJECTS, true);
            m2eCorePrefs.putBoolean(P_DEFAULT_POM_EDITOR_PAGE, true);
            m2eCorePrefs.putBoolean(P_UPDATE_INDEXES, false);
            try {
                m2eCorePrefs.flush();
            }
            catch (BackingStoreException e) {
                this.handleException(e);
            }
        }
    }

    public void enhanceJDTPreferences() {
        IEclipsePreferences jdtUiPrefs;
        IEclipsePreferences jdtCorePrefs = InstanceScope.INSTANCE.getNode(JDT_CORE_BUNDLE_ID);
        if (jdtCorePrefs != null) {
            jdtCorePrefs.put(COMPILER_PB_NON_NLS_STRING_LITERAL, "ignore");
            try {
                jdtCorePrefs.flush();
            }
            catch (BackingStoreException e) {
                this.handleException(e);
            }
        }
        if ((jdtUiPrefs = InstanceScope.INSTANCE.getNode(JDT_UI_BUNDLE_ID)) != null) {
            jdtUiPrefs.putBoolean(EDITOR_SMART_PASTE, true);
            jdtUiPrefs.putBoolean(EDITOR_ESCAPE_STRINGS, true);
            jdtUiPrefs.putInt(CODEASSIST_AUTOACTIVATION_DELAY, 40);
            jdtUiPrefs.putBoolean(EDITOR_SMART_SEMICOLON, true);
            jdtUiPrefs.putBoolean(EDITOR_SMART_OPENING_BRACE, true);
            jdtUiPrefs.putBoolean(EDITOR_SMART_BACKSPACE, true);
            jdtUiPrefs.putBoolean(EDITOR_SMART_TAB, true);
            try {
                jdtUiPrefs.flush();
            }
            catch (BackingStoreException e) {
                this.handleException(e);
            }
        }
    }

    public void undoAll() {
        this.undoJDTEnhance();
        this.undoM2EEnhance();
    }

    public void undoJDTEnhance() {
        IEclipsePreferences jdtUiPrefs;
        IEclipsePreferences jdtCorePrefs = InstanceScope.INSTANCE.getNode(JDT_CORE_BUNDLE_ID);
        if (jdtCorePrefs != null) {
            jdtCorePrefs.remove(COMPILER_PB_NON_NLS_STRING_LITERAL);
            try {
                jdtCorePrefs.flush();
            }
            catch (BackingStoreException e) {
                this.handleException(e);
            }
        }
        if ((jdtUiPrefs = InstanceScope.INSTANCE.getNode(JDT_UI_BUNDLE_ID)) != null) {
            jdtUiPrefs.remove(EDITOR_SMART_PASTE);
            jdtUiPrefs.remove(EDITOR_ESCAPE_STRINGS);
            jdtUiPrefs.remove(CODEASSIST_AUTOACTIVATION_DELAY);
            jdtUiPrefs.remove(CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVA);
            jdtUiPrefs.remove(EDITOR_SMART_SEMICOLON);
            jdtUiPrefs.remove(EDITOR_SMART_OPENING_BRACE);
            jdtUiPrefs.remove(EDITOR_SMART_BACKSPACE);
            jdtUiPrefs.remove(EDITOR_SMART_TAB);
            try {
                jdtUiPrefs.flush();
            }
            catch (BackingStoreException e) {
                this.handleException(e);
            }
        }
    }

    public void undoM2EEnhance() {
        IEclipsePreferences m2eCorePrefs = InstanceScope.INSTANCE.getNode(M2E_CORE_BUNDLE_ID);
        if (m2eCorePrefs != null) {
            m2eCorePrefs.remove(P_HIDE_FOLDERS_OF_NESTED_PROJECTS);
            m2eCorePrefs.remove(P_DEFAULT_POM_EDITOR_PAGE);
            m2eCorePrefs.remove(P_UPDATE_INDEXES);
            try {
                m2eCorePrefs.flush();
            }
            catch (BackingStoreException e) {
                this.handleException(e);
            }
        }
    }

    private void handleException(BackingStoreException e) {
        CorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", e.getLocalizedMessage(), (Throwable)e));
    }
}

