/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.springsource.ide.eclipse.commons.core.ICommandHistory;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.internal.core.commandhistory.CommandHistory;

public class CommandHistoryProvider {
    private static final Map<String, ICommandHistory> COMMAND_HISTORIES = new HashMap<String, ICommandHistory>();

    public static synchronized ICommandHistory getCommandHistory(String historyId, String natureId) {
        String key = CommandHistoryProvider.getKey(historyId, natureId);
        if (COMMAND_HISTORIES.containsKey(key)) {
            return COMMAND_HISTORIES.get(key);
        }
        try {
            CommandHistory commandHistory = new CommandHistory(historyId, natureId, true);
            COMMAND_HISTORIES.put(key, commandHistory);
            return commandHistory;
        }
        catch (CoreException e) {
            CorePlugin.log("Warning: couldn't get persistent command history, using non-persistent history instead", e);
            return new CommandHistory(historyId, natureId);
        }
    }

    private static String getKey(String historyId, String natureId) {
        Assert.isNotNull((Object)historyId);
        Assert.isNotNull((Object)natureId);
        return historyId + "_" + natureId;
    }
}

