/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.data.internal.DataCorePlugin;

public class DataCoreImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.data.core.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.data.core.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    public static final String IMG_OBJS_KEY = "org.springframework.ide.eclipse.data.core.key_obj.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_KEY;

    static {
        try {
            ICON_BASE_URL = new URL(DataCorePlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            DataCorePlugin.log(e);
        }
        DESC_OBJS_KEY = DataCoreImages.createManaged(OBJECT, IMG_OBJS_KEY);
    }

    static void initializeImageRegistry(ImageRegistry registry) {
        for (String key : imageDescriptors.keySet()) {
            registry.put(key, imageDescriptors.get(key));
        }
    }

    public static Image getImage(String key) {
        return DataCorePlugin.getDefault().getImageRegistry().get(key);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)DataCoreImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            DataCorePlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/').append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

