/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicConstants;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizard;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewSideMenuWizardPage;
import org.jboss.tools.jst.angularjs.internal.ui.AngularJsUIImages;

public class NewSideMenuWizard
extends NewIonicWidgetWizard<NewSideMenuWizardPage>
implements IonicConstants {
    static String prefixId = "sidemenu-";

    public NewSideMenuWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(AngularJsUIImages.getInstance().getOrCreateImageDescriptor(AngularJsUIImages.SIDEMENU_IMAGE));
    }

    protected NewSideMenuWizardPage createPage() {
        return new NewSideMenuWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent, boolean browser) {
        boolean addRightMenuToggle;
        IElementGenerator.ElementNode header;
        boolean hasHeader;
        IElementGenerator.ElementNode menus = parent.addChild("ion-side-menus");
        this.addAttributeIfNotEmpty(menus, "delegate-handle", "delegate-handle");
        this.addID(prefixId, menus);
        IElementGenerator.ElementNode content = menus.addChild("ion-side-menu-content", null);
        if (!this.isTrue("drag-content")) {
            content.addAttribute("drag-content", "false");
        }
        this.addAttributeIfNotEmpty(content, "edge-drag-threshold", "edge-drag-threshold");
        if (this.isTrue("left-menu")) {
            IElementGenerator.ElementNode leftMenu = menus.addChild("ion-side-menu", null);
            leftMenu.addAttribute("side", "left");
            boolean bl = hasHeader = ((NewSideMenuWizardPage)this.page).getEditorValue("left-menu-title").length() > 0;
            if (hasHeader) {
                header = leftMenu.addChild("ion-header-bar");
                header.addChild("h4", ((NewSideMenuWizardPage)this.page).getEditorValue("left-menu-title"));
            }
            IElementGenerator.ElementNode leftContent = leftMenu.addChild("ion-content");
            if (hasHeader) {
                leftContent.addAttribute("class", "has-header");
            }
            leftContent.addComment("left menu content");
            if (!this.isTrue("left-menu-enabled")) {
                leftMenu.addAttribute("is-enabled", "false");
            }
            this.addAttributeIfNotEmpty(leftMenu, "width", "left-menu-width");
        }
        if (this.isTrue("right-menu")) {
            IElementGenerator.ElementNode rightMenu = menus.addChild("ion-side-menu", null);
            rightMenu.addAttribute("side", "right");
            boolean bl = hasHeader = ((NewSideMenuWizardPage)this.page).getEditorValue("right-menu-title").length() > 0;
            if (hasHeader) {
                header = rightMenu.addChild("ion-header-bar");
                header.addChild("h4", ((NewSideMenuWizardPage)this.page).getEditorValue("right-menu-title"));
            }
            IElementGenerator.ElementNode rightContent = rightMenu.addChild("ion-content");
            if (hasHeader) {
                rightContent.addAttribute("class", "has-header");
            }
            rightContent.addComment("right menu content");
            if (!this.isTrue("right-menu-enabled")) {
                rightMenu.addAttribute("is-enabled", "false");
            }
            this.addAttributeIfNotEmpty(rightMenu, "width", "right-menu-width");
        }
        boolean addLeftMenuToggle = this.isTrue("left-menu") && this.isTrue("left-menu-toggle");
        boolean bl = addRightMenuToggle = this.isTrue("right-menu") && this.isTrue("right-menu-toggle");
        if (addLeftMenuToggle || addRightMenuToggle) {
            IElementGenerator.ElementNode button;
            IElementGenerator.ElementNode buttons;
            IElementGenerator.ElementNode bar = content.addChild("ion-nav-bar");
            if (addLeftMenuToggle) {
                buttons = bar.addChild("ion-nav-buttons");
                buttons.addAttribute("class", "bar-stable nav-title-slide-ios7");
                button = buttons.addChild("button", "");
                buttons.addAttribute("side", "left");
                button.addAttribute("menu-toggle", "left");
                button.addAttribute("class", "button button-icon icon ion-navicon");
            }
            if (addRightMenuToggle) {
                buttons = bar.addChild("ion-nav-buttons");
                buttons.addAttribute("class", "bar-stable nav-title-slide-ios7");
                button = buttons.addChild("button", "");
                buttons.addAttribute("side", "right");
                button.addAttribute("menu-toggle", "right");
                button.addAttribute("class", "button button-icon icon ion-navicon");
            }
            IElementGenerator.ElementNode view = content.addChild("ion-view", "");
            view.addAttribute("title", "Title");
        }
        if (browser) {
            content.addChild("ion-view").addChild("ion-content", "content");
        } else {
            content.addChild("ion-view").addChild("ion-content").addComment("center content");
        }
    }
}

