/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.operations.CancellableOperationMonitorThread;
import org.eclipse.mylyn.commons.core.operations.ICancellableOperation;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.repositories.http.core.CancellableInputStream;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;

public class CommonHttpResponse
implements ICancellableOperation {
    private CancellableInputStream entityStream;
    private final IOperationMonitor monitor;
    private final HttpRequest request;
    private final HttpResponse response;
    private final CancellableOperationMonitorThread monitorThread;

    public CommonHttpResponse(HttpRequest request, HttpResponse response, CancellableOperationMonitorThread monitorThread, IOperationMonitor monitor) {
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)response);
        Assert.isNotNull((Object)monitorThread);
        Assert.isNotNull((Object)monitor);
        this.request = request;
        this.response = response;
        this.monitorThread = monitorThread;
        this.monitor = monitor;
    }

    public CommonHttpResponse(HttpRequest request, HttpResponse response, IOperationMonitor monitor) {
        this(request, response, CancellableOperationMonitorThread.getInstance(), monitor);
    }

    @Deprecated
    public CommonHttpResponse(HttpRequest request, HttpResponse response) {
        this(request, response, CancellableOperationMonitorThread.getInstance(), OperationUtil.convert(null));
    }

    public void abort() {
        this.abortStream();
        if (this.request instanceof HttpUriRequest) {
            try {
                ((HttpUriRequest)this.request).abort();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public String getRequestPath() {
        if (this.request instanceof HttpUriRequest) {
            return ((HttpUriRequest)this.request).getURI().getPath();
        }
        return null;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getResponseCharSet() {
        return EntityUtils.getContentCharSet((HttpEntity)this.response.getEntity());
    }

    public synchronized InputStream getResponseEntityAsStream() throws IOException {
        if (this.entityStream != null) {
            throw new IllegalStateException();
        }
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            throw new IOException("Expected entity");
        }
        this.entityStream = new CancellableInputStream(this, entity.getContent());
        this.monitorThread.addOperation((ICancellableOperation)this);
        return this.entityStream;
    }

    @Deprecated
    public InputStream getResponseEntityAsStream(IProgressMonitor monitor) throws IOException {
        return this.getResponseEntityAsStream();
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void release() {
        this.releaseStream();
        HttpUtil.release(this.request, this.response, (IProgressMonitor)this.monitor);
    }

    @Deprecated
    public void release(IProgressMonitor monitor) {
        this.release();
    }

    private synchronized void abortStream() {
        if (this.entityStream != null) {
            CancellableOperationMonitorThread.getInstance().removeOperation((ICancellableOperation)this);
            this.entityStream.cancel();
        }
    }

    private synchronized void releaseStream() {
        if (this.entityStream != null) {
            CancellableOperationMonitorThread.getInstance().removeOperation((ICancellableOperation)this);
            this.entityStream = null;
        }
    }

    void notifyStreamClosed() {
        this.release();
    }
}

