/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.config.ui.wizards.ConfigWizardsMessages;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceSelectionWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "xsdPage";
    private static final int XSD_LIST_VIEWER_HEIGHT = 150;
    private static final int LIST_VIEWER_WIDTH = 340;
    private CheckboxTableViewer xsdViewer;
    private CheckboxTableViewer versionViewer;
    private final Map<INamespaceDefinition, String> selectedNamespaceVersionMap = new HashMap<INamespaceDefinition, String>();
    private INamespaceDefinition selectedNamespaceDefinition;
    private final Element beansElement;
    private List<INamespaceDefinition> namespaceDefinitionList = null;
    private INamespaceDefinition defaultNamespace = null;
    private final IFile file;

    protected NamespaceSelectionWizardPage(String pageName, Element beansElement, IFile file) {
        super(pageName);
        this.beansElement = beansElement;
        this.file = file;
        this.setTitle(ConfigWizardsMessages.NamespaceConfig_title);
        this.setDescription(ConfigWizardsMessages.NamespaceConfig_xsdDescription);
    }

    private String attributeNameToPrefix(String attributeName, String uri) {
        int colonIndex = attributeName.indexOf(":");
        if (attributeName.length() > 6 && attributeName.indexOf(":") > 0) {
            return attributeName.substring(colonIndex + 1, attributeName.length());
        }
        if (attributeName.equals("xmlns")) {
            return uri.substring(uri.lastIndexOf("/") + 1);
        }
        return null;
    }

    private void checkForDefaultNamespace() {
        if (this.defaultNamespace == null) {
            return;
        }
        Object[] checkedElements = this.xsdViewer.getCheckedElements();
        if (checkedElements != null) {
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object currElement = objectArray[n2];
                if (currElement.equals(this.defaultNamespace)) {
                    this.setErrorMessage(null);
                    this.setDescription(ConfigWizardsMessages.NamespaceConfig_xsdDescription);
                    this.setPageComplete(true);
                    return;
                }
                ++n2;
            }
            this.setErrorMessage(ConfigWizardsMessages.NamespaceConfig_mustIncludeDefault);
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        this.namespaceDefinitionList = this.getNamespaceDefinitionList();
        this.defaultNamespace = this.getDefaultNamespaceDefinition(this.namespaceDefinitionList);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.setControl((Control)composite);
        Label namespaceLabel = new Label(composite, 0);
        namespaceLabel.setText(ConfigWizardsMessages.NamespaceConfig_selectNamespace);
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 150;
        this.xsdViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.xsdViewer.getTable().setLayoutData((Object)gd);
        this.xsdViewer.setContentProvider((IContentProvider)new XsdConfigContentProvider());
        this.xsdViewer.setLabelProvider((IBaseLabelProvider)new XsdLabelProvider());
        this.xsdViewer.setInput((Object)this);
        this.xsdViewer.setCheckedElements(this.getPreselectedElements());
        this.xsdViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    NamespaceSelectionWizardPage.this.selectedNamespaceDefinition = (INamespaceDefinition)obj;
                    NamespaceSelectionWizardPage.this.versionViewer.setInput(obj);
                    if (NamespaceSelectionWizardPage.this.selectedNamespaceVersionMap.containsKey(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)) {
                        NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[]{((String)NamespaceSelectionWizardPage.this.selectedNamespaceVersionMap.get(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)).trim()});
                    }
                    if (NamespaceSelectionWizardPage.this.xsdViewer.getChecked(obj) && NamespaceSelectionWizardPage.this.selectedNamespaceDefinition.getSchemaLocations().size() > 0) {
                        NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(true);
                    } else {
                        NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(false);
                    }
                    NamespaceSelectionWizardPage.this.checkForDefaultNamespace();
                }
            }
        });
        this.xsdViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                NamespaceSelectionWizardPage.this.selectedNamespaceDefinition = (INamespaceDefinition)obj;
                NamespaceSelectionWizardPage.this.versionViewer.setInput(obj);
                if (NamespaceSelectionWizardPage.this.selectedNamespaceVersionMap.containsKey(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)) {
                    NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[]{((String)NamespaceSelectionWizardPage.this.selectedNamespaceVersionMap.get(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition)).trim()});
                }
                if (event.getChecked() && NamespaceSelectionWizardPage.this.selectedNamespaceDefinition != null && NamespaceSelectionWizardPage.this.selectedNamespaceDefinition.getSchemaLocations().size() > 0) {
                    NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(true);
                } else {
                    NamespaceSelectionWizardPage.this.versionViewer.getControl().setEnabled(false);
                }
            }
        });
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(ConfigWizardsMessages.NamespaceConfig_selectSpecificXsd);
        this.versionViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.versionViewer.getTable().setLayoutData((Object)gd);
        this.versionViewer.setContentProvider((IContentProvider)new VersionContentProvider());
        this.versionViewer.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.versionViewer.setSorter(new ViewerSorter());
        this.versionViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[]{event.getElement()});
                    if (NamespaceSelectionWizardPage.this.selectedNamespaceDefinition != null) {
                        NamespaceSelectionWizardPage.this.selectedNamespaceVersionMap.put(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition, (String)event.getElement());
                    }
                } else {
                    NamespaceSelectionWizardPage.this.versionViewer.setCheckedElements(new Object[0]);
                    NamespaceSelectionWizardPage.this.selectedNamespaceVersionMap.remove(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition);
                }
            }
        });
    }

    private boolean existsInConfiguration(INamespaceDefinition namespaceDefinition) {
        NamedNodeMap attributeMap = this.beansElement.getAttributes();
        int i = 0;
        while (i < attributeMap.getLength()) {
            Node currItem = attributeMap.item(i);
            if (currItem.getNodeName().equals("xmlns:" + namespaceDefinition.getNamespacePrefix((IResource)this.file))) {
                return true;
            }
            if (currItem.getNodeName().equals("xmlns") && currItem.getNodeValue().equals(namespaceDefinition.getNamespaceURI())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private INamespaceDefinition getDefaultNamespaceDefinition(List<INamespaceDefinition> namespaceDefinitions) {
        NamedNodeMap beanAttributes = this.beansElement.getAttributes();
        int i = 0;
        while (i < beanAttributes.getLength()) {
            Node currAttributeNode = beanAttributes.item(i);
            String currAttributeName = currAttributeNode.getNodeName();
            String uri = currAttributeNode.getNodeValue();
            if (currAttributeName.equalsIgnoreCase("xmlns")) {
                for (INamespaceDefinition currNamespaceDefinition : namespaceDefinitions) {
                    if (!currNamespaceDefinition.getNamespaceURI().equals(uri)) continue;
                    return currNamespaceDefinition;
                }
            }
            ++i;
        }
        return null;
    }

    private List<INamespaceDefinition> getNamespaceDefinitionList() {
        if (this.namespaceDefinitionList == null) {
            this.namespaceDefinitionList = new ArrayList<INamespaceDefinition>();
            this.namespaceDefinitionList.addAll(NamespaceUtils.getNamespaceDefinitions());
            NamedNodeMap beanAttributes = this.beansElement.getAttributes();
            int i = 0;
            while (i < beanAttributes.getLength()) {
                String uri;
                Node currAttributeNode = beanAttributes.item(i);
                String currAttributeName = currAttributeNode.getNodeName();
                if (this.isUnknownNamespace(currAttributeName, uri = currAttributeNode.getNodeValue(), this.namespaceDefinitionList)) {
                    String schemaVersion = this.getSchemaVersionFromXml(uri);
                    DefaultNamespaceDefinition namespaceDefinition = new DefaultNamespaceDefinition(this.attributeNameToPrefix(currAttributeName, uri), uri, schemaVersion, StsUiImages.XML_FILE.createImage());
                    if (!"".equals(schemaVersion)) {
                        this.selectedNamespaceVersionMap.put((INamespaceDefinition)namespaceDefinition, schemaVersion);
                    }
                    this.namespaceDefinitionList.add((INamespaceDefinition)namespaceDefinition);
                }
                ++i;
            }
        }
        return this.namespaceDefinitionList;
    }

    private Object[] getPreselectedElements() {
        Object[] availableNamespaces;
        HashSet<INamespaceDefinition> checkedElements = new HashSet<INamespaceDefinition>();
        Object[] objectArray = availableNamespaces = ((IStructuredContentProvider)this.xsdViewer.getContentProvider()).getElements(null);
        int n = availableNamespaces.length;
        int n2 = 0;
        while (n2 < n) {
            Object currAvailableNamespace = objectArray[n2];
            INamespaceDefinition currNamespaceDefinition = (INamespaceDefinition)currAvailableNamespace;
            if (this.existsInConfiguration(currNamespaceDefinition)) {
                checkedElements.add(currNamespaceDefinition);
                String existingVersion = this.getSchemaVersionFromXml(currNamespaceDefinition.getNamespaceURI());
                if (!"".equals(existingVersion)) {
                    this.selectedNamespaceVersionMap.put(currNamespaceDefinition, existingVersion);
                }
            }
            ++n2;
        }
        return checkedElements.toArray();
    }

    private String getSchemaVersionFromXml(String namespaceUri) {
        String schemaLocationValue = this.beansElement.getAttribute("xsi:schemaLocation");
        schemaLocationValue = schemaLocationValue.replaceAll("\\n|\\t", " ");
        schemaLocationValue = schemaLocationValue.replaceAll(" +", " ");
        String[] schemaVersions = schemaLocationValue.split(" ");
        int i = 0;
        while (i < schemaVersions.length) {
            String currSchema = schemaVersions[i];
            if (currSchema.equals(namespaceUri) && i + 1 < schemaVersions.length) {
                return schemaVersions[i + 1];
            }
            ++i;
        }
        return "";
    }

    public Map<INamespaceDefinition, String> getSchemaVersions() {
        return this.selectedNamespaceVersionMap;
    }

    public List<INamespaceDefinition> getXmlSchemaDefinitions() {
        ArrayList<INamespaceDefinition> defs = new ArrayList<INamespaceDefinition>();
        Object[] checkedElements = this.xsdViewer.getCheckedElements();
        if (checkedElements != null) {
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                defs.add((INamespaceDefinition)element);
                ++n2;
            }
        }
        return defs;
    }

    private boolean isUnknownNamespace(String attributeName, String namespaceUri, List<INamespaceDefinition> namespaceDefinitionList) {
        if (attributeName.toLowerCase().startsWith("xmlns:xsi")) {
            return false;
        }
        if (attributeName.toLowerCase().startsWith("xmlns:") && !this.namespaceAttributeExistsInList(attributeName, namespaceUri, namespaceDefinitionList) && this.attributeNameToPrefix(attributeName, namespaceUri) != null) {
            return true;
        }
        return attributeName.equalsIgnoreCase("xmlns") && !this.namespaceAttributeExistsInList(attributeName, namespaceUri, namespaceDefinitionList);
    }

    private boolean namespaceAttributeExistsInList(String attributeName, String namespaceUri, List<INamespaceDefinition> namespaces) {
        String namespacePrefix = this.attributeNameToPrefix(attributeName, namespaceUri);
        for (INamespaceDefinition namespaceDefinition : namespaces) {
            INamespaceDefinition currNamespaceDefinition = namespaceDefinition;
            if (!currNamespaceDefinition.getNamespacePrefix((IResource)this.file).equals(namespacePrefix) && !namespaceUri.equalsIgnoreCase(currNamespaceDefinition.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    private class VersionContentProvider
    implements IStructuredContentProvider {
        private VersionContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            if (obj instanceof INamespaceDefinition) {
                return ((INamespaceDefinition)obj).getSchemaLocations().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VersionLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String label = (String)element;
                if (NamespaceSelectionWizardPage.this.selectedNamespaceDefinition != null && label.equals(NamespaceSelectionWizardPage.this.selectedNamespaceDefinition.getDefaultSchemaLocation((IResource)NamespaceSelectionWizardPage.this.file))) {
                    label = String.valueOf(label) + " " + ConfigWizardsMessages.NamespaceConfig_default;
                }
                return label;
            }
            return super.getText(element);
        }
    }

    private class XsdConfigContentProvider
    implements IStructuredContentProvider {
        private XsdConfigContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return NamespaceSelectionWizardPage.this.getNamespaceDefinitionList().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class XsdLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof INamespaceDefinition) {
                INamespaceDefinition xsdDef = (INamespaceDefinition)element;
                return xsdDef.getNamespaceImage();
            }
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof INamespaceDefinition) {
                INamespaceDefinition xsdDef = (INamespaceDefinition)element;
                return String.valueOf(xsdDef.getNamespacePrefix((IResource)NamespaceSelectionWizardPage.this.file)) + " - " + xsdDef.getNamespaceURI();
            }
            return "";
        }
    }
}

