/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model;

import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.schemas.WebFlowSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.LabelledTransition;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model.AbstractStateModelElement;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model.IfElseTransition;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model.IfThenTransition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecisionStateModelElement
extends AbstractStateModelElement {
    public DecisionStateModelElement() {
    }

    public DecisionStateModelElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    public String getInputName() {
        return WebFlowSchemaConstants.ELEM_DECISION_STATE;
    }

    @Override
    protected List<Transition> getOutgoingTransitionsFromXml() {
        List<Transition> list = super.getOutgoingTransitionsFromXml();
        List registry = this.getDiagram().getModelRegistry();
        NodeList transitions = this.getInput().getChildNodes();
        int i = 0;
        while (i < transitions.getLength()) {
            Node node = transitions.item(i);
            if (node instanceof IDOMElement && node.getLocalName().equals(WebFlowSchemaConstants.ELEM_IF)) {
                LabelledTransition trans;
                Node stateRef;
                IDOMElement transition = (IDOMElement)node;
                String state = transition.getAttribute(WebFlowSchemaConstants.ATTR_THEN);
                if (state != null && state.trim().length() > 0 && (stateRef = this.getDiagram().getReferencedNode(state)) instanceof IDOMElement) {
                    for (Activity activity : registry) {
                        if (activity instanceof ParallelActivity || !activity.getInput().equals(stateRef)) continue;
                        trans = new IfThenTransition(this, activity, transition);
                        list.add((Transition)trans);
                    }
                }
                if ((state = transition.getAttribute(WebFlowSchemaConstants.ATTR_ELSE)) != null && state.trim().length() > 0 && (stateRef = this.getDiagram().getReferencedNode(state)) instanceof IDOMElement) {
                    for (Activity activity : registry) {
                        if (activity instanceof ParallelActivity || !activity.getInput().equals(stateRef)) continue;
                        trans = new IfElseTransition(this, activity, transition);
                        list.add((Transition)trans);
                    }
                }
            }
            ++i;
        }
        return list;
    }
}

