/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph.model;

import java.util.Arrays;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.ui.editors.integration.graph.model.AlternateTransition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecipientListRouterModelElement
extends Activity {
    public RecipientListRouterModelElement() {
    }

    public RecipientListRouterModelElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    public String getInputName() {
        return IntegrationSchemaConstants.ELEM_RECIPIENT_LIST_ROUTER;
    }

    public List<String> getPrimaryIncomingAttributes() {
        return Arrays.asList(IntegrationSchemaConstants.ATTR_INPUT_CHANNEL);
    }

    public List<String> getPrimaryOutgoingAttributes() {
        return Arrays.asList(IntegrationSchemaConstants.ATTR_OUTPUT_CHANNEL);
    }

    protected List<Transition> getOutgoingTransitionsFromXml() {
        List list = super.getOutgoingTransitionsFromXml();
        List registry = this.getDiagram().getModelRegistry();
        NodeList mappings = this.getInput().getChildNodes();
        int i = 0;
        while (i < mappings.getLength()) {
            Node channelRef;
            IDOMElement recipient;
            String channel;
            Node node = mappings.item(i);
            if (node instanceof IDOMElement && node.getLocalName().equals(IntegrationSchemaConstants.ELEM_RECIPIENT) && (channel = (recipient = (IDOMElement)node).getAttribute(IntegrationSchemaConstants.ATTR_CHANNEL)) != null && channel.trim().length() > 0 && (channelRef = this.getDiagram().getReferencedNode(channel)) instanceof IDOMElement) {
                for (Activity activity : registry) {
                    if (activity instanceof ParallelActivity || !activity.getInput().equals(channelRef)) continue;
                    AlternateTransition trans = new AlternateTransition(this, activity, (IDOMNode)recipient);
                    list.add(trans);
                }
            }
            ++i;
        }
        return list;
    }
}

