/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.config.core.IConfigEditorPage;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.Messages;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigGraphPage;
import org.springframework.ide.eclipse.config.ui.editors.namespaces.NamespacesFormPage;
import org.springframework.ide.eclipse.config.ui.editors.overview.OverviewFormPage;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Node;

public class SpringConfigEditor
extends AbstractConfigEditor
implements IPropertyListener {
    public static final String ID_EDITOR = "com.springsource.sts.config.ui.editors.SpringConfigEditor";
    private NamespacesFormPage namespacesPage;
    private OverviewFormPage overviewPage;
    private SpringConfigGraphPage graphPage;
    private boolean requiresDeferredBeanGraph = false;

    public SpringConfigEditor() {
        this.addPropertyListener(this);
    }

    private void addBeanGraphPage(IBeansConfig config) {
        GraphEditorInput graphInput = null;
        try {
            graphInput = new GraphEditorInput(config.getElementID());
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_CREATING_BEANS_GRAPH"), (Throwable)e));
        }
        if (graphInput != null) {
            try {
                this.graphPage = new SpringConfigGraphPage(this);
                int graphIndex = this.addPage((IEditorPart)this.graphPage, (IEditorInput)graphInput);
                this.setPageText(graphIndex, Messages.getString("SpringConfigEditor.GRAPH_TAB"));
            }
            catch (PartInitException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_CREATING_BEANS_GRAPH"), (Throwable)e));
            }
        }
    }

    private void createBeanGraphPage() {
        boolean gefEnabled = this.getPreferenceStore().getBoolean("com.springsource.config.ui.prefs.enable.gef");
        if (gefEnabled) {
            IBeansConfig config = BeansCorePlugin.getModel().getConfig(this.getResourceFile());
            if (config != null) {
                this.addBeanGraphPage(config);
            } else {
                this.requiresDeferredBeanGraph = true;
            }
        }
    }

    protected void createDeferredBeanGraphPage() {
        IBeansConfig config;
        boolean gefEnabled = this.getPreferenceStore().getBoolean("com.springsource.config.ui.prefs.enable.gef");
        if (!gefEnabled) {
            this.requiresDeferredBeanGraph = false;
        }
        if (this.requiresDeferredBeanGraph && (config = BeansCorePlugin.getModel().getConfig(this.getResourceFile())) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SpringConfigEditor.this.addBeanGraphPage(config);
                }
            });
            this.requiresDeferredBeanGraph = false;
        }
    }

    @Override
    protected void createPreNamespacePages() {
        this.namespacesPage = new NamespacesFormPage(this);
        this.overviewPage = new OverviewFormPage(this);
        this.addConfigEditorPage(this.namespacesPage, Messages.getString("SpringConfigEditor.NAMESPACES_TAB"));
        this.addConfigEditorPage(this.overviewPage, Messages.getString("SpringConfigEditor.OVERVIEW_TAB"));
    }

    @Override
    public void dispose() {
        this.removePropertyListener(this);
        super.dispose();
    }

    public SpringConfigGraphPage getBeansGraphPage() {
        return this.graphPage;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257 && this.graphPage != null) {
            this.graphPage.updateHeader();
        }
    }

    private void removeBeanGraphPage() {
        if (this.graphPage != null && this.pages.contains((Object)this.graphPage)) {
            this.removePage(this.pages.indexOf((Object)this.graphPage));
            this.graphPage = null;
        }
    }

    @Override
    public void revealElement(Node element) {
        String uri = element.getNamespaceURI();
        if (uri != null) {
            AbstractConfigFormPage page = this.getFormPageForUri(uri);
            if (page == null) {
                page = this.overviewPage;
            }
            this.setActivePage(page.getId());
            page.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    @Override
    protected void setActivePageFromPreference(Integer index, IConfigEditorPage activePage) {
        if (activePage == null && index != null && this.graphPage != null && index >= this.pages.indexOf((Object)this.graphPage)) {
            this.setActiveEditor((IEditorPart)this.graphPage);
        } else {
            super.setActivePageFromPreference(index, activePage);
        }
    }

    @Override
    protected void updateContentOutline(int newPageIndex) {
        if (this.getContentOutline() != null) {
            IContentOutlinePage outline = null;
            Object activePage = this.pages.get(newPageIndex);
            if (activePage instanceof SpringConfigGraphPage) {
                outline = (IContentOutlinePage)this.graphPage.getAdapter(IContentOutlinePage.class);
            }
            if (outline != null) {
                this.getContentOutline().setActiveOutline(outline);
            } else {
                super.updateContentOutline(newPageIndex);
            }
        }
    }

    @Override
    protected void updateNamespacePages() {
        this.removeBeanGraphPage();
        super.updateNamespacePages();
        this.createBeanGraphPage();
    }
}

