/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalAdapter;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalProvider;
import org.springframework.ide.eclipse.config.core.contentassist.providers.ToolAnnotationContentProposalProvider;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigDetailsSectionPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.widgets.AbstractAttributeWidget;
import org.springframework.ide.eclipse.config.ui.widgets.HyperlinkedTextAttribute;
import org.springframework.ide.eclipse.config.ui.widgets.TextAttributeProposalAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringConfigDetailsSectionPart
extends AbstractConfigDetailsSectionPart {
    private final SpringConfigContentAssistProcessor processor;
    private final List<AbstractAttributeWidget> widgets;
    private final List<XmlBackedContentProposalAdapter> adapters;
    private List<CMAttributeDeclaration> attrDecls;

    public SpringConfigDetailsSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit) {
        super(editor, input, parent, toolkit);
        this.processor = editor.getXmlProcessor();
        this.widgets = new ArrayList<AbstractAttributeWidget>();
        this.adapters = new ArrayList<XmlBackedContentProposalAdapter>();
        this.attrDecls = this.processor.getAttributeDeclarations(input);
    }

    protected void addAdapter(XmlBackedContentProposalAdapter adapter) {
        this.adapters.add(adapter);
    }

    private void addComboAttribute(Composite client, String attr, String[] enumStrs, boolean required) {
        boolean hasEmptyStr = false;
        String[] enumStrsCopy = new String[enumStrs.length + 1];
        enumStrsCopy[0] = "";
        int i = 0;
        while (i < enumStrs.length) {
            enumStrsCopy[i + 1] = enumStrs[i];
            if (enumStrs[0].trim().length() == 0) {
                hasEmptyStr = true;
            }
            ++i;
        }
        if (!hasEmptyStr) {
            enumStrs = enumStrsCopy;
        }
        this.widgets.add(this.createComboAttribute(client, attr, enumStrs, required));
    }

    protected boolean addCustomAttribute(Composite client, String attr, boolean required) {
        return false;
    }

    private void addTextAttribute(Composite client, String attr, boolean required) {
        boolean widgetCreated = false;
        List appInfo = ToolAnnotationUtils.getApplicationInformationElements((Node)this.getInput(), (String)attr);
        if (!appInfo.isEmpty()) {
            for (Element element : appInfo) {
                NodeList children = element.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node annotation = children.item(i);
                    ToolAnnotationUtils.ToolAnnotationData data = ToolAnnotationUtils.getToolAnnotationData((Node)annotation);
                    if (!widgetCreated) {
                        HyperlinkedTextAttribute attrWidget = null;
                        if (data.getExpectedType() != null && data.getExpectedType().equalsIgnoreCase(Class.class.getName())) {
                            attrWidget = this.createClassAttribute(client, attr, true, required);
                        } else if (data.getKind() != null || data.getExpectedMethodType() != null || data.getExpectedMethodRef() != null || data.getExpectedMethodExpression() != null) {
                            attrWidget = this.createToolAnnotationAttribute(client, attr, required);
                        }
                        if (attrWidget != null) {
                            this.widgets.add(attrWidget);
                            this.adapters.add(new TextAttributeProposalAdapter(attrWidget, (XmlBackedContentProposalProvider)new ToolAnnotationContentProposalProvider(this.getInput(), attr)));
                            widgetCreated = true;
                        }
                    }
                    ++i;
                }
            }
        }
        if (!widgetCreated && !this.addCustomAttribute(client, attr.toLowerCase(), required)) {
            this.widgets.add(this.createTextAttribute(client, attr, required));
        }
    }

    protected void addWidget(AbstractAttributeWidget widget) {
        this.widgets.add(widget);
    }

    @Override
    protected void createAttributes(Composite client) {
        if (this.attrDecls.isEmpty() && this.processor.allowsCharacterData(this.getInput())) {
            this.widgets.add(this.createTextArea(client, this.getInput().getLocalName()));
        } else {
            Collections.sort(this.attrDecls, new CMAttributeDeclarationComparator());
            for (CMAttributeDeclaration attrDecl : this.attrDecls) {
                boolean required = this.processor.isRequiredAttribute(attrDecl);
                String attr = attrDecl.getNodeName();
                String[] enumStrs = attrDecl.getAttrType().getEnumeratedValues();
                if (enumStrs != null && enumStrs.length > 0) {
                    this.addComboAttribute(client, attr, enumStrs, required);
                    continue;
                }
                this.addTextAttribute(client, attr, required);
            }
        }
    }

    public void refresh() {
        for (AbstractAttributeWidget widget : this.widgets) {
            widget.update();
        }
        for (XmlBackedContentProposalAdapter adapter : this.adapters) {
            adapter.update(this.getInput());
        }
        super.refresh();
    }

    @Override
    public boolean setFormInput(Object input) {
        boolean result = super.setFormInput(input);
        this.attrDecls = this.processor.getAttributeDeclarations(this.getInput());
        return result;
    }

    private class CMAttributeDeclarationComparator
    implements Comparator<CMAttributeDeclaration> {
        private CMAttributeDeclarationComparator() {
        }

        @Override
        public int compare(CMAttributeDeclaration o1, CMAttributeDeclaration o2) {
            String name1 = o1.getNodeName();
            String name2 = o2.getNodeName();
            boolean required1 = SpringConfigDetailsSectionPart.this.processor.isRequiredAttribute(o1);
            boolean required2 = SpringConfigDetailsSectionPart.this.processor.isRequiredAttribute(o2);
            if (name1.equalsIgnoreCase(BeansSchemaConstants.ATTR_ID)) {
                return -1;
            }
            if (name2.equalsIgnoreCase(BeansSchemaConstants.ATTR_ID)) {
                return 1;
            }
            if (required1 && required2) {
                return name1.compareToIgnoreCase(name2);
            }
            if (required1) {
                return -1;
            }
            if (required2) {
                return 1;
            }
            return name1.compareToIgnoreCase(name2);
        }
    }
}

