/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class AvoidDefaultSerializableInInnerClasses
extends Check {
    public static final String MSG_KEY = "avoid.default.serializable.in.inner.classes";
    private boolean allowPartialImplementation;

    public void setAllowPartialImplementation(boolean allow) {
        this.allowPartialImplementation = allow;
    }

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST detailAST) {
        boolean topLevelClass;
        boolean bl = topLevelClass = detailAST.getParent() == null;
        if (!topLevelClass && AvoidDefaultSerializableInInnerClasses.isSerializable(detailAST) && !AvoidDefaultSerializableInInnerClasses.isStatic(detailAST) && !this.hasSerialazableMethods(detailAST)) {
            DetailAST implementsBlock = detailAST.findFirstToken(19);
            this.log(implementsBlock.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isStatic(DetailAST classNode) {
        boolean result = false;
        DetailAST modifiers = classNode.findFirstToken(5);
        for (modifiers = modifiers.getFirstChild(); !result && modifiers != null; modifiers = modifiers.getNextSibling()) {
            result = "static".equals(modifiers.getText());
        }
        return result;
    }

    private boolean hasSerialazableMethods(DetailAST classNode) {
        DetailAST objectBody = classNode.findFirstToken(6);
        int numberOfSerializationMethods = 0;
        SiblingIterator methodsIter = new SiblingIterator(objectBody);
        while (methodsIter.hasNextSibling()) {
            DetailAST methodNode = methodsIter.nextSibling();
            if (AvoidDefaultSerializableInInnerClasses.isPrivateMethod(methodNode) && AvoidDefaultSerializableInInnerClasses.isVoidMethod(methodNode) && (AvoidDefaultSerializableInInnerClasses.hasCorrectParameter(methodNode, "ObjectInputStream") || AvoidDefaultSerializableInInnerClasses.hasCorrectParameter(methodNode, "ObjectOutputStream"))) {
                ++numberOfSerializationMethods;
            }
            if ((numberOfSerializationMethods != 1 || !this.allowPartialImplementation) && numberOfSerializationMethods != 2) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrivateMethod(DetailAST methodNode) {
        DetailAST modifiers = methodNode.findFirstToken(5);
        boolean isPrivate = false;
        for (modifiers = modifiers.getFirstChild(); !isPrivate && modifiers != null; modifiers = modifiers.getNextSibling()) {
            isPrivate = "private".equals(modifiers.getText());
        }
        return isPrivate;
    }

    private static boolean isVoidMethod(DetailAST methodNode) {
        DetailAST type = methodNode.findFirstToken(13);
        return 49 == (type = type.getFirstChild()).getType();
    }

    private static boolean hasCorrectParameter(DetailAST methodNode, String parameterText) {
        DetailAST parameters = methodNode.findFirstToken(20);
        boolean result = false;
        if (parameters.getChildCount(21) == 1) {
            parameters = parameters.findFirstToken(21);
            parameters = parameters.findFirstToken(13);
            parameters = parameters.getFirstChild();
            result = parameterText.equals(parameters.getText());
        }
        return result;
    }

    private static boolean isSerializable(DetailAST classDefNode) {
        DetailAST implementationsDef = classDefNode.findFirstToken(19);
        boolean result = false;
        if (implementationsDef != null) {
            for (implementationsDef = implementationsDef.getFirstChild(); !result && implementationsDef != null; implementationsDef = implementationsDef.getNextSibling()) {
                if (implementationsDef.getType() == 59) {
                    implementationsDef = implementationsDef.getLastChild();
                }
                result = "Serializable".equals(implementationsDef.getText());
            }
        }
        return result;
    }

    private class SiblingIterator {
        private DetailAST next;

        public SiblingIterator(DetailAST parent) {
            this.next = parent.findFirstToken(9);
        }

        public boolean hasNextSibling() {
            return this.next != null;
        }

        public DetailAST nextSibling() {
            DetailAST result = this.next;
            while (this.next != null) {
                this.next = this.next.getNextSibling();
                if (this.next == null || this.next.getType() != 9) continue;
                break;
            }
            return result;
        }
    }
}

