/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.parser;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_EXTENSION = ".dtd";
    private static final String[] DTD_NAMES = new String[]{"spring-beans-2.0", "spring-beans"};
    private static final String SEARCH_PACKAGE = "/org/springframework/beans/factory/xml/";

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (systemId != null && systemId.endsWith(DTD_EXTENSION)) {
            int lastPathSeparator = systemId.lastIndexOf("/");
            String[] stringArray = DTD_NAMES;
            int n = DTD_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String dtdName = stringArray[n2];
                int dtdNameStart = systemId.indexOf(dtdName);
                if (dtdNameStart > lastPathSeparator) {
                    String dtdFile = systemId.substring(dtdNameStart);
                    try {
                        ClassPathResource resource = new ClassPathResource(SEARCH_PACKAGE + dtdFile, this.getClass());
                        InputSource source = new InputSource(resource.getInputStream());
                        source.setPublicId(publicId);
                        source.setSystemId(systemId);
                        return source;
                    }
                    catch (IOException e) {
                        BeansCorePlugin.log("Could not resolve beans DTD [" + systemId + "]: not found in class path", e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

