/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.update.IBeansModelUpdate;

public abstract class BeansModelUpdater {
    private static final List<IBeansModelUpdate> UPDATES = new ArrayList<IBeansModelUpdate>();

    public static void updateModel(Collection<IBeansProject> projects) {
        for (IBeansProject project : projects) {
            BeansModelUpdater.updateProject(project);
        }
    }

    public static void updateProject(IBeansProject project) {
        for (IBeansModelUpdate update : UPDATES) {
            project.getConfigs();
            if (!update.requiresUpdate(project)) continue;
            UpdateJob job = new UpdateJob(project, update);
            job.setPriority(40);
            job.setRule((ISchedulingRule)project.getProject());
            job.schedule();
        }
    }

    private static class UpdateJob
    extends Job {
        private final IBeansProject project;
        private final IBeansModelUpdate update;

        public UpdateJob(IBeansProject project, IBeansModelUpdate update) {
            super("Updating Spring Project '" + project.getElementName() + "' with update '" + update.getName() + "'");
            this.project = project;
            this.update = update;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.update.updateProject(this.project);
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

