/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigFactory;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.BeansResourceChangeListener;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.IBeansResourceChangeEvents;
import org.springframework.ide.eclipse.beans.core.internal.model.update.BeansModelUpdater;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IReloadableBeansConfig;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.model.AbstractModel;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.util.ObjectUtils;

public class BeansModel
extends AbstractModel
implements IBeansModel {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/model/debug";
    public static final boolean DEBUG = SpringCore.isDebug((String)"org.springframework.ide.eclipse.beans.core/model/debug");
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    protected volatile boolean modelPopulated = false;
    private volatile Map<IProject, IBeansProject> projects = new ConcurrentHashMap<IProject, IBeansProject>();
    private IResourceChangeListener workspaceListener;
    private IFacetedProjectListener facetedProjectListener;

    public BeansModel() {
        super(null, "BeansModel");
        BeansCorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(BeansCorePlugin.DISABLE_AUTO_DETECTION)) {
                    for (IModelElement iModelElement : BeansModel.this.getProjects()) {
                        if (!(iModelElement instanceof BeansProject)) continue;
                        BeansProject p = (BeansProject)iModelElement;
                        p.reset();
                        ((BeansModel)p.getElementParent()).notifyListeners(p, ModelChangeEvent.Type.CHANGED);
                    }
                }
            }
        });
    }

    public IModelElement[] getElementChildren() {
        return this.getProjects().toArray(new IModelElement[this.getProjects().size()]);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        try {
            this.r.lock();
            for (IBeansProject project : this.projects.values()) {
                project.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            this.r.unlock();
        }
    }

    public void start() {
        if (DEBUG) {
            System.out.println("Beans Model startup");
        }
        try {
            this.w.lock();
            this.projects.clear();
            for (IProject project : SpringCoreUtils.getSpringProjects()) {
                BeansProject beansProject = new BeansProject(this, project);
                this.addProject(beansProject);
            }
            for (IBeansProject beanProject : this.projects.values()) {
                beanProject.accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element, IProgressMonitor monitor) {
                        return element instanceof IBeansProject;
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            BeansModelUpdater.updateModel(this.projects.values());
        }
        finally {
            this.modelPopulated = true;
            this.w.unlock();
        }
        this.workspaceListener = new BeansResourceChangeListener(new ResourceChangeEventHandler());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.workspaceListener, 62);
        this.facetedProjectListener = new FacetProjectFrameworkListener();
        FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetedProjectListener, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.POST_INSTALL, IFacetedProjectEvent.Type.POST_UNINSTALL});
    }

    public void addProject(IBeansProject project) {
        this.projects.put(project.getProject(), project);
    }

    public void stop() {
        if (DEBUG) {
            System.out.println("Beans Model shutdown");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.workspaceListener);
        this.workspaceListener = null;
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetedProjectListener);
        this.facetedProjectListener = null;
        try {
            this.w.lock();
            this.projects.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public IBeansProject getProject(IProject project) {
        try {
            this.r.lock();
            IBeansProject iBeansProject = this.projects.get(project);
            return iBeansProject;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public IBeansProject getProject(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int configNamePos = name.indexOf(47, name.charAt(0) == '/' ? 1 : 0);
        if (configNamePos > 0) {
            name = name.substring(0, configNamePos);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(name);
        return this.getProject(project);
    }

    @Override
    public Set<IBeansProject> getProjects() {
        try {
            this.r.lock();
            Set<IBeansProject> set = Collections.unmodifiableSet(new HashSet<IBeansProject>(this.projects.values()));
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public IBeansConfig getConfig(IFile configFile) {
        return this.getConfig(configFile, true);
    }

    @Override
    public IBeansConfig getConfig(IFile configFile, boolean includeImported) {
        if (configFile != null) {
            IBeansConfig bc;
            IBeansProject project = this.getProject(configFile.getProject());
            if (project != null && (bc = project.getConfig(configFile, includeImported)) != null) {
                return bc;
            }
            for (IBeansProject p : this.getProjects()) {
                IBeansConfig bc2 = p.getConfig(configFile, includeImported);
                if (bc2 == null) continue;
                return bc2;
            }
        }
        return null;
    }

    @Override
    public boolean isConfig(IFile configFile, boolean includeImported) {
        if (configFile != null) {
            try {
                Object configFileTag;
                if (configFile.isAccessible() && !"taggedAsPotentialConfigFile".equals(configFileTag = configFile.getSessionProperty(IBeansConfig.CONFIG_FILE_TAG))) {
                    return false;
                }
            }
            catch (CoreException e) {
                BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", String.format("Error occured while reading the config file tag for file '%s'", configFile.getFullPath()), (Throwable)e));
            }
            IBeansProject project = this.getProject(configFile.getProject());
            String configName = null;
            if (project != null && project.hasConfig(configFile, configName = !(configFile instanceof ExternalFile) ? configFile.getProjectRelativePath().toString() : configFile.getFullPath().toString(), includeImported)) {
                return true;
            }
            configName = configFile.getFullPath().toString();
            for (IBeansProject p : this.getProjects()) {
                if (!p.hasConfig(configFile, configName, includeImported)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<IBeansConfig> getConfigs(IFile configFile, boolean includeImported) {
        LinkedHashSet<IBeansConfig> beansConfigs = new LinkedHashSet<IBeansConfig>();
        if (configFile != null) {
            for (IBeansProject p : this.getProjects()) {
                beansConfigs.addAll(p.getConfigs(configFile, includeImported));
            }
        }
        return beansConfigs;
    }

    @Override
    public IBeansConfig getConfig(String configName) {
        int configNamePos = configName.indexOf(47, configName.charAt(0) == '/' ? 1 : 0);
        if (configNamePos > 0) {
            String projectName = configName.substring(1, configNamePos);
            configName = configName.substring(configNamePos + 1);
            IBeansProject project = BeansCorePlugin.getModel().getProject(projectName);
            if (project != null) {
                return project.getConfig(configName);
            }
        }
        return null;
    }

    @Override
    public Set<IBeansConfig> getConfigs(String className) {
        LinkedHashSet<IBeansConfig> configs = new LinkedHashSet<IBeansConfig>();
        try {
            this.r.lock();
            for (IBeansProject project : this.projects.values()) {
                for (IBeansConfig config : project.getConfigs()) {
                    if (!config.isBeanClass(className)) continue;
                    configs.add(config);
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return configs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansModel)) {
            return false;
        }
        try {
            this.r.lock();
            BeansModel that = (BeansModel)other;
            if (!ObjectUtils.nullSafeEquals(this.projects, that.projects)) {
                return false;
            }
        }
        finally {
            this.r.unlock();
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.projects);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer("Beans model:\n");
        try {
            this.r.lock();
            for (IBeansProject project : this.projects.values()) {
                text.append(" Configs of project '");
                text.append(project.getElementName());
                text.append("':\n");
                for (IBeansConfig config : project.getConfigs()) {
                    text.append("  ");
                    text.append(config);
                    text.append('\n');
                    for (IBean bean : config.getBeans()) {
                        text.append("   ");
                        text.append(bean);
                        text.append('\n');
                    }
                }
                text.append(" Config sets of project '");
                text.append(project.getElementName());
                text.append("':\n");
                for (IBeansConfigSet configSet : project.getConfigSets()) {
                    text.append("  ");
                    text.append(configSet);
                    text.append('\n');
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return text.toString();
    }

    public boolean isInitialized() {
        try {
            this.r.lock();
            boolean bl = this.modelPopulated;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    private void buildProject(IResource resource, boolean build) {
        BeansProject project = null;
        try {
            this.r.lock();
            project = (BeansProject)this.projects.get(resource.getProject());
        }
        finally {
            this.r.unlock();
        }
        if (project != null) {
            project.reset();
            this.notifyListeners(project, ModelChangeEvent.Type.CHANGED);
            if (build) {
                SpringCoreUtils.buildProject((IProject)project.getProject());
            }
        }
    }

    private class FacetProjectFrameworkListener
    implements IFacetedProjectListener {
        private FacetProjectFrameworkListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            IFacetedProject fProject = event.getProject();
            if (SpringCoreUtils.isSpringProject((IResource)fProject.getProject())) {
                if (DEBUG) {
                    System.out.println(String.format("Project facet on '%s' changed. Triggering re-build.", fProject.getProject().getName()));
                }
                BeansModel.this.buildProject((IResource)fProject.getProject(), false);
            }
        }
    }

    public class ResourceChangeEventHandler
    implements IBeansResourceChangeEvents {
        public boolean isSpringProject(IProject project, int eventType) {
            return BeansModel.this.getProject(project) != null;
        }

        public void springNatureAdded(IProject project, int eventType) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Spring beans nature added to project '" + project.getName() + "'");
                }
                BeansProject proj = new BeansProject(BeansModel.this, project);
                try {
                    BeansModel.this.w.lock();
                    BeansModel.this.projects.put(project, proj);
                }
                finally {
                    BeansModel.this.w.unlock();
                }
                BeansModel.this.notifyListeners(proj, ModelChangeEvent.Type.CHANGED);
                SpringCoreUtils.buildProject((IProject)project);
            }
        }

        public void springNatureRemoved(IProject project, int eventType) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Spring beans nature removed from project '" + project.getName() + "'");
                }
                IBeansProject proj = null;
                try {
                    BeansModel.this.w.lock();
                    proj = (IBeansProject)BeansModel.this.projects.remove(project);
                }
                finally {
                    BeansModel.this.w.unlock();
                }
                if (proj != null) {
                    BeansModel.this.notifyListeners(proj, ModelChangeEvent.Type.CHANGED);
                }
            }
        }

        public void projectAdded(IProject project, int eventType) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Project '" + project.getName() + "' added");
                }
                BeansProject proj = new BeansProject(BeansModel.this, project);
                try {
                    BeansModel.this.w.lock();
                    BeansModel.this.projects.put(project, proj);
                    BeansModelUpdater.updateProject(proj);
                }
                finally {
                    BeansModel.this.w.unlock();
                }
                BeansModel.this.notifyListeners(proj, ModelChangeEvent.Type.ADDED);
            }
        }

        public void projectOpened(IProject project, int eventType) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Project '" + project.getName() + "' opened");
                }
                BeansProject proj = new BeansProject(BeansModel.this, project);
                try {
                    BeansModel.this.w.lock();
                    BeansModel.this.projects.put(project, proj);
                    BeansModelUpdater.updateProject(proj);
                }
                finally {
                    BeansModel.this.w.unlock();
                }
                BeansModel.this.notifyListeners(proj, ModelChangeEvent.Type.ADDED);
            }
        }

        public void projectClosed(IProject project, int eventType) {
            if (DEBUG) {
                System.out.println("Project '" + project.getName() + "' closed");
            }
            IBeansProject proj = null;
            try {
                BeansModel.this.w.lock();
                proj = (IBeansProject)BeansModel.this.projects.remove(project);
            }
            finally {
                BeansModel.this.w.unlock();
            }
            if (proj != null) {
                BeansModel.this.notifyListeners(proj, ModelChangeEvent.Type.REMOVED);
            }
        }

        public void projectDeleted(IProject project, int eventType) {
            if (DEBUG) {
                System.out.println("Project '" + project.getName() + "' deleted");
            }
            IBeansProject proj = null;
            try {
                BeansModel.this.w.lock();
                proj = (IBeansProject)BeansModel.this.projects.remove(project);
            }
            finally {
                BeansModel.this.w.unlock();
            }
            if (proj != null) {
                BeansModel.this.notifyListeners(proj, ModelChangeEvent.Type.REMOVED);
            }
        }

        @Override
        public void projectDescriptionChanged(IFile file, int eventType) {
            if (eventType == 16 && !SpringCoreUtils.isManifest((IResource)file)) {
                if (DEBUG) {
                    System.out.println("Project description '" + file.getFullPath() + "' changed");
                }
                BeansModel.this.buildProject((IResource)file, true);
            } else if (eventType == 8 && SpringCoreUtils.isManifest((IResource)file)) {
                if (DEBUG) {
                    System.out.println("Project manifest '" + file.getFullPath() + "' changed");
                }
                BeansModel.this.buildProject((IResource)file, true);
            }
        }

        @Override
        public void configAdded(IFile file, int eventType, IBeansConfig.Type type) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Config '" + file.getFullPath() + "' added");
                }
                BeansProject project = null;
                try {
                    BeansModel.this.r.lock();
                    project = (BeansProject)BeansModel.this.projects.get(file.getProject());
                }
                finally {
                    BeansModel.this.r.unlock();
                }
                if (!BeansConfigFactory.isJavaConfigFile(file) && project.addConfig(file, type)) {
                    if (type == IBeansConfig.Type.AUTO_DETECTED) {
                        BeansModel.this.buildProject((IResource)file, true);
                        BeansModel.this.notifyListeners(project, ModelChangeEvent.Type.CHANGED);
                    } else {
                        project.saveDescription();
                    }
                }
                IBeansConfig config = project.getConfig(file);
                BeansModel.this.notifyListeners(config, ModelChangeEvent.Type.ADDED);
            }
        }

        @Override
        public void configAdded(IFile file, int eventType) {
            this.configAdded(file, eventType, IBeansConfig.Type.MANUAL);
        }

        @Override
        public void configChanged(IFile file, int eventType) {
            LinkedHashSet<IReloadableBeansConfig> configs = new LinkedHashSet<IReloadableBeansConfig>();
            try {
                BeansModel.this.r.lock();
                Set<IBeansConfig> bcs = BeansModel.this.getConfigs(file, true);
                for (IBeansConfig bc : bcs) {
                    if (bc instanceof IImportedBeansConfig) {
                        configs.add(BeansModelUtils.getParentOfClass(bc, IReloadableBeansConfig.class));
                        continue;
                    }
                    if (!(bc instanceof IReloadableBeansConfig)) continue;
                    configs.add((IReloadableBeansConfig)bc);
                }
            }
            finally {
                BeansModel.this.r.unlock();
            }
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Config '" + file.getFullPath() + "' changed");
                }
                for (IReloadableBeansConfig config : configs) {
                    BeansModel.this.notifyListeners(config, ModelChangeEvent.Type.CHANGED);
                }
            } else {
                for (IReloadableBeansConfig config : configs) {
                    config.reload();
                }
            }
        }

        @Override
        public void configRemoved(IFile file, int eventType) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Config '" + file.getFullPath() + "' removed");
                }
                BeansProject project = null;
                try {
                    BeansModel.this.r.lock();
                    project = (BeansProject)BeansModel.this.projects.get(file.getProject());
                }
                finally {
                    BeansModel.this.r.unlock();
                }
                if (project == null) {
                    return;
                }
                IBeansConfig config = project.getConfig(file);
                if (project.removeConfig(file)) {
                    project.saveDescription();
                }
                try {
                    BeansModel.this.r.lock();
                    for (IBeansProject proj : BeansModel.this.projects.values()) {
                        if (!((BeansProject)proj).removeConfig(file)) continue;
                        ((BeansProject)proj).saveDescription();
                    }
                }
                finally {
                    BeansModel.this.r.unlock();
                }
                if (config != null) {
                    BeansModel.this.notifyListeners(config, ModelChangeEvent.Type.REMOVED);
                }
            }
        }

        @Override
        public void listenedFileChanged(IFile file, int eventType) {
            if (eventType == 16) {
                if (DEBUG) {
                    System.out.println("Watched resource '" + file.getFullPath() + "' changed");
                }
                BeansModel.this.buildProject((IResource)file, false);
            }
        }
    }
}

