/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.util.Util;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.parsing.EmptyReaderEventListener;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.UniqueBeanNameGenerator;
import org.springframework.ide.eclipse.beans.core.internal.model.process.BeansConfigPostProcessorFactory;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigEventListener;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IReloadableBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessor;
import org.springframework.ide.eclipse.beans.core.namespaces.IModelElementProvider;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.classreading.CachingJdtMetadataReaderFactory;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public class BeansJavaConfig
extends AbstractBeansConfig
implements IBeansConfig,
ILazyInitializedModelElement,
IReloadableBeansConfig {
    private IType configClass;
    private String configClassName;
    private BeansConfigProblemReporter problemReporter;
    private UniqueBeanNameGenerator beanNameGenerator;
    private ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry registry;
    private transient IModelElement[] children;

    public BeansJavaConfig(IBeansProject project, IType configClass, String configClassName, IBeansConfig.Type type) {
        super(project, "java:" + configClassName, type);
        this.configClass = configClass;
        this.configClassName = configClassName;
        this.modificationTimestamp = -1L;
        if (this.configClass != null) {
            IResource resource = this.configClass.getResource();
            if (resource != null && resource instanceof IFile) {
                this.file = (IFile)resource;
            } else {
                IClassFile classFile = configClass.getClassFile();
                PackageFragment pkg = (PackageFragment)configClass.getPackageFragment();
                IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
                if (root.isArchive()) {
                    IPath zipPath = root.getPath();
                    String classFileName = classFile.getElementName();
                    String path = Util.concatWith((String[])pkg.names, (String)classFileName, (char)'/');
                    this.file = new ExternalFile(zipPath.toFile(), path, project.getProject());
                }
            }
        }
        if (this.file == null || !this.file.exists()) {
            this.modificationTimestamp = -1L;
            String msg = "Beans Java config class '" + configClassName + "' not accessible";
            this.problems = new CopyOnWriteArraySet();
            this.problems.add(new ValidationProblem(2, msg, (IResource)this.file, -1, new ValidationProblemAttribute[0]));
        } else {
            this.modificationTimestamp = this.file.getModificationStamp();
            try {
                this.file.setSessionProperty(IBeansConfig.CONFIG_FILE_TAG, (Object)"taggedAsPotentialConfigFile");
            }
            catch (CoreException e) {
                BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", String.format("Error occured while tagging config file '%s'", this.file.getFullPath()), (Throwable)e));
            }
        }
    }

    public IType getConfigClass() {
        return this.configClass;
    }

    public String getConfigClassName() {
        return this.configClassName;
    }

    public boolean isInitialized() {
        return this.isModelPopulated;
    }

    public IModelElement[] getElementChildren() {
        this.readConfig();
        try {
            this.r.lock();
            IModelElement[] iModelElementArray = this.children;
            return iModelElementArray;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Set<IBeansImport> getImports() {
        return Collections.emptySet();
    }

    @Override
    public int getElementStartLine() {
        return JdtUtils.getLineNumber((IJavaElement)this.configClass);
    }

    @Override
    protected void readConfig() {
        if (!this.isModelPopulated) {
            ClassLoader cl;
            block13: {
                IBeansProject beansProject;
                block12: {
                    block11: {
                        this.w.lock();
                        if (this.isModelPopulated) {
                            this.w.unlock();
                            return;
                        }
                        if (this.configClass != null) break block11;
                        ArrayList allChildren = new ArrayList(this.imports);
                        allChildren.addAll(this.aliases.values());
                        allChildren.addAll(this.components);
                        allChildren.addAll(this.beans.values());
                        Collections.sort(allChildren, new Comparator<ISourceModelElement>(){

                            @Override
                            public int compare(ISourceModelElement element1, ISourceModelElement element2) {
                                return element1.getElementStartLine() - element2.getElementStartLine();
                            }
                        });
                        this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
                        this.isModelPopulated = true;
                        this.w.unlock();
                        return;
                    }
                    beansProject = BeansModelUtils.getParentOfClass(this, IBeansProject.class);
                    if (beansProject != null) break block12;
                    ArrayList allChildren = new ArrayList(this.imports);
                    allChildren.addAll(this.aliases.values());
                    allChildren.addAll(this.components);
                    allChildren.addAll(this.beans.values());
                    Collections.sort(allChildren, new /* invalid duplicate definition of identical inner class */);
                    this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
                    this.isModelPopulated = true;
                    this.w.unlock();
                    return;
                }
                cl = JdtUtils.getClassLoader((IProject)beansProject.getProject(), (ClassLoader)ApplicationContext.class.getClassLoader());
                if (cl.getResource(String.valueOf(this.configClass.getFullyQualifiedName().replace('.', '/')) + ".class") != null) break block13;
                ArrayList allChildren = new ArrayList(this.imports);
                allChildren.addAll(this.aliases.values());
                allChildren.addAll(this.components);
                allChildren.addAll(this.beans.values());
                Collections.sort(allChildren, new /* invalid duplicate definition of identical inner class */);
                this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
                this.isModelPopulated = true;
                this.w.unlock();
                return;
            }
            try {
                Callable<Integer> loadBeanDefinitionOperation = new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl);
                        BeansConfigPostProcessorReaderEventListener eventListener = new BeansConfigPostProcessorReaderEventListener();
                        BeansJavaConfig.this.problemReporter = new BeansConfigProblemReporter();
                        BeansJavaConfig.this.beanNameGenerator = new UniqueBeanNameGenerator(BeansJavaConfig.this);
                        BeansJavaConfig.this.registry = new ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry();
                        try {
                            IBeansConfigPostProcessor[] postProcessors;
                            BeansJavaConfig.this.registerAnnotationProcessors((ReaderEventListener)eventListener);
                            BeansJavaConfig.this.registerBean((ReaderEventListener)eventListener, cl);
                            IBeansConfigPostProcessor[] iBeansConfigPostProcessorArray = postProcessors = BeansConfigPostProcessorFactory.createPostProcessor(ConfigurationClassPostProcessor.class.getName());
                            int n = postProcessors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IBeansConfigPostProcessor postProcessor = iBeansConfigPostProcessorArray[n2];
                                BeansJavaConfig.this.executePostProcessor(postProcessor, (ReaderEventListener)eventListener);
                                ++n2;
                            }
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(threadClassLoader);
                            LogFactory.release((ClassLoader)cl);
                        }
                        return 0;
                    }
                };
                FutureTask<Integer> task = new FutureTask<Integer>(loadBeanDefinitionOperation);
                BeansCorePlugin.getExecutorService().submit(task);
                task.get(BeansCorePlugin.getDefault().getPreferenceStore().getInt("org.springframework.ide.eclipse.beans.core.timeoutConfigLoading"), TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.problems.add(new ValidationProblem(2, "Loading of configuration '" + this.configClass.getFullyQualifiedName() + "' took more than " + BeansCorePlugin.getDefault().getPreferenceStore().getInt("org.springframework.ide.eclipse.beans.core.timeoutConfigLoading") + "sec", (IResource)this.file, 1, new ValidationProblemAttribute[0]));
                ArrayList allChildren = new ArrayList(this.imports);
                allChildren.addAll(this.aliases.values());
                allChildren.addAll(this.components);
                allChildren.addAll(this.beans.values());
                Collections.sort(allChildren, new /* invalid duplicate definition of identical inner class */);
                this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
                this.isModelPopulated = true;
                this.w.unlock();
            }
            catch (Exception e) {
                ArrayList allChildren;
                try {
                    this.problems.add(new ValidationProblem(2, String.format("Error occured processing Java config '%s'. See Error Log for more details", e.getCause().getMessage()), this.getElementResource()));
                    BeansCorePlugin.log((IStatus)new Status(1, "org.springframework.ide.eclipse.beans.core", String.format("Error occured processing '%s'", this.configClass.getFullyQualifiedName()), e.getCause()));
                    allChildren = new ArrayList(this.imports);
                    allChildren.addAll(this.aliases.values());
                }
                catch (Throwable throwable) {
                    ArrayList allChildren2 = new ArrayList(this.imports);
                    allChildren2.addAll(this.aliases.values());
                    allChildren2.addAll(this.components);
                    allChildren2.addAll(this.beans.values());
                    Collections.sort(allChildren2, new /* invalid duplicate definition of identical inner class */);
                    this.children = allChildren2.toArray(new IModelElement[allChildren2.size()]);
                    this.isModelPopulated = true;
                    this.w.unlock();
                    throw throwable;
                }
                allChildren.addAll(this.components);
                allChildren.addAll(this.beans.values());
                Collections.sort(allChildren, new /* invalid duplicate definition of identical inner class */);
                this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
                this.isModelPopulated = true;
                this.w.unlock();
            }
            ArrayList allChildren = new ArrayList(this.imports);
            allChildren.addAll(this.aliases.values());
            allChildren.addAll(this.components);
            allChildren.addAll(this.beans.values());
            Collections.sort(allChildren, new /* invalid duplicate definition of identical inner class */);
            this.children = allChildren.toArray(new IModelElement[allChildren.size()]);
            this.isModelPopulated = true;
            this.w.unlock();
        }
    }

    @Override
    public void reload() {
        if (this.configClass != null) {
            try {
                this.w.lock();
                this.isModelPopulated = false;
                this.modificationTimestamp = -1L;
                this.defaults = null;
                this.imports.clear();
                this.aliases.clear();
                this.beans.clear();
                this.components.clear();
                this.isBeanClassesMapPopulated = false;
                this.beanClassesMap.clear();
                this.problems.clear();
                this.children = null;
            }
            finally {
                this.w.unlock();
            }
            for (IBeansConfigEventListener eventListener : this.eventListeners) {
                eventListener.onReset(this);
            }
        }
    }

    private void executePostProcessor(final IBeansConfigPostProcessor postProcessor, final ReaderEventListener eventListener) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                BeansCorePlugin.log(exception);
            }

            public void run() throws Exception {
                postProcessor.postProcess(BeansConfigPostProcessorFactory.createPostProcessingContext(BeansJavaConfig.this, BeansJavaConfig.this.beans.values(), eventListener, BeansJavaConfig.this.problemReporter, BeansJavaConfig.this.beanNameGenerator, (BeanDefinitionRegistry)BeansJavaConfig.this.registry, BeansJavaConfig.this.problems));
            }
        });
    }

    private void registerComponentDefinition(ComponentDefinition componentDefinition, Map<String, IModelElementProvider> elementProviders) {
        ISourceModelElement element;
        String uri = NamespaceUtils.getNameSpaceURI((BeanMetadataElement)componentDefinition);
        IModelElementProvider provider = elementProviders.get(uri);
        if (provider == null) {
            provider = BeansConfig.DEFAULT_ELEMENT_PROVIDER;
        }
        if ((element = provider.getElement(this, componentDefinition)) instanceof IBean) {
            this.beans.put(element.getElementName(), (IBean)element);
        } else if (element instanceof IBeansComponent) {
            this.components.add((IBeansComponent)element);
        }
    }

    public void registerBean(ReaderEventListener eventListener, ClassLoader classloader) throws IOException {
        IJavaProject project = this.configClass.getJavaProject();
        if (project == null) {
            return;
        }
        CachingJdtMetadataReaderFactory metadataReaderFactory = new CachingJdtMetadataReaderFactory(project, classloader);
        MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(this.configClass.getFullyQualifiedName());
        AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(metadataReader.getAnnotationMetadata());
        abd.setScope("singleton");
        AnnotationBeanNameGenerator nameGenerator = new AnnotationBeanNameGenerator();
        String beanName = nameGenerator.generateBeanName((BeanDefinition)abd, (BeanDefinitionRegistry)this.registry);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)abd, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)this.registry);
        eventListener.componentRegistered((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)abd, beanName));
    }

    protected void registerAnnotationProcessors(ReaderEventListener eventListener) {
        Set processorDefinitions = AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)this.registry, null);
        for (BeanDefinitionHolder processorDefinition : processorDefinitions) {
            eventListener.componentRegistered((ComponentDefinition)new BeanComponentDefinition(processorDefinition));
        }
    }

    @Override
    public boolean doesAnnotationScanning() {
        return true;
    }

    @Override
    public BeanDefinitionRegistry getRawBeanDefinitions(CompositeComponentDefinition context) {
        return null;
    }

    class BeansConfigPostProcessorReaderEventListener
    extends EmptyReaderEventListener {
        final Map<String, IModelElementProvider> elementProviders = NamespaceUtils.getElementProviders();

        BeansConfigPostProcessorReaderEventListener() {
        }

        public void componentRegistered(ComponentDefinition componentDefinition) {
            if (componentDefinition.getSource() == null && componentDefinition instanceof BeanComponentDefinition) {
                try {
                    AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)((BeanComponentDefinition)componentDefinition).getBeanDefinition();
                    abstractBeanDefinition.setSource((Object)new JavaModelSourceLocation((IJavaElement)BeansJavaConfig.this.configClass));
                    abstractBeanDefinition.setRole(2);
                }
                catch (JavaModelException e) {
                    SpringCore.log((Throwable)e);
                }
            }
            BeansJavaConfig.this.registerComponentDefinition(componentDefinition, this.elementProviders);
        }
    }

    class BeansConfigProblemReporter
    implements ProblemReporter {
        BeansConfigProblemReporter() {
        }

        public void error(Problem problem) {
        }

        public void fatal(Problem problem) {
        }

        public void warning(Problem problem) {
        }
    }

    class ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry
    extends SimpleBeanDefinitionRegistry {
        ScannedGenericBeanDefinitionSuppressingBeanDefinitionRegistry() {
        }

        public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
            if (beanDefinition instanceof ScannedGenericBeanDefinition) {
                super.registerBeanDefinition(beanName, (BeanDefinition)new BeansConfig.InternalScannedGenericBeanDefinition((ScannedGenericBeanDefinition)beanDefinition));
            } else {
                super.registerBeanDefinition(beanName, beanDefinition);
            }
        }
    }
}

