/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.OverrideAndUpdateSynchronizeOperation;

public class OverrideAndUpdateSynchronizeAction
extends SynchronizeModelAction {
    public OverrideAndUpdateSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter(){

            public boolean select(SyncInfo info) {
                FastSyncInfoFilter.SyncInfoDirectionFilter filter = new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12});
                if (!filter.select(info)) {
                    return false;
                }
                IStructuredSelection selection = OverrideAndUpdateSynchronizeAction.this.getStructuredSelection();
                boolean removeUnAdded = SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
                for (ISynchronizeModelElement element : selection) {
                    ISVNLocalResource svnResource;
                    block9: {
                        block8: {
                            IResource resource = element.getResource();
                            if (resource == null) {
                                return false;
                            }
                            svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                            if (svnResource == null) {
                                return false;
                            }
                            try {
                                if (resource.exists() || svnResource.getStatusFromCache().isDeleted()) break block8;
                                return false;
                            }
                            catch (SVNException sVNException) {
                                return false;
                            }
                        }
                        if (!svnResource.isAdded()) break block9;
                        return false;
                    }
                    if (removeUnAdded || svnResource.isManaged()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        ArrayList<IResource> selectedResources = new ArrayList<IResource>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ISynchronizeModelElement) {
                selectedResources.add(((ISynchronizeModelElement)elements[i]).getResource());
            }
            ++i;
        }
        IResource[] resources = new IResource[selectedResources.size()];
        selectedResources.toArray(resources);
        return new OverrideAndUpdateSynchronizeOperation(configuration, elements, resources, resources);
    }
}

