/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;

public class CompareDialog
extends SubclipseTrayDialog {
    private CompareEditorInput compareEditorInput;
    private IDialogSettings settings;

    public CompareDialog(Shell shell, CompareEditorInput input) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        Assert.isNotNull((Object)input);
        this.compareEditorInput = input;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    private boolean compareResultOK(CompareEditorInput input) {
        Shell shell;
        block5: {
            shell = this.getShell();
            SVNUIPlugin.getPlugin().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message == null) break block5;
            MessageDialog.openError((Shell)shell, (String)Policy.bind("CompareDialog.compareFailed"), (String)message);
            return false;
        }
        try {
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)input.getTitle(), (String)Policy.bind("CompareDialog.noDifferences"));
                return false;
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)Policy.bind("CompareDialog.compareFailed"), (String)x.getTargetException().getMessage());
        }
        return false;
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("CompareDialog.location.x");
            int y = this.settings.getInt("CompareDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("CompareDialog.size.x");
            int y = this.settings.getInt("CompareDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return new Point(this.getShell().getSize().x - 300, this.getShell().getSize().y - 100);
        }
    }

    public int open() {
        if (this.compareResultOK(this.compareEditorInput)) {
            return super.open();
        }
        return 7;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        Control c = this.compareEditorInput.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        Shell shell = c.getShell();
        shell.setText(this.compareEditorInput.getTitle());
        shell.setImage(this.compareEditorInput.getTitleImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.tigris.subversion.subclipse.ui.compare_dialog_context");
        CompareDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("CompareDialog.location.x", x);
        this.settings.put("CompareDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("CompareDialog.size.x", x);
        this.settings.put("CompareDialog.size.y", y);
    }
}

