/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.compare.IPropertyProvider;
import org.tigris.subversion.subclipse.ui.compare.PropertyCompareLocalResourceNode;
import org.tigris.subversion.subclipse.ui.compare.PropertyCompareRemoteResourceNode;
import org.tigris.subversion.subclipse.ui.dialogs.ComparePropertiesDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CompareSvnPropertiesAction
extends WorkbenchWindowAction {
    private IPropertyProvider right;
    private Exception exception;

    public void execute(IAction action) {
        this.exception = null;
        IResource[] resources = this.getSelectedResources();
        IStructureComparator left = null;
        this.right = null;
        if (resources != null && resources.length > 0) {
            left = new PropertyCompareLocalResourceNode(resources[0], true, null);
            if (resources.length > 1) {
                this.right = new PropertyCompareLocalResourceNode(resources[1], true, null);
            } else {
                final ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0]);
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            CompareSvnPropertiesAction.this.right = new PropertyCompareRemoteResourceNode(svnResource.getRemoteResource(SVNRevision.HEAD), SVNRevision.HEAD, true, null);
                        }
                        catch (SVNException e) {
                            CompareSvnPropertiesAction.this.exception = (Exception)((Object)e);
                        }
                    }
                });
                if (this.exception != null) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CompareSvnPropertiesAction.0"), (String)this.exception.getMessage());
                    return;
                }
            }
        } else {
            ISVNRemoteResource[] remoteResources = this.getSelectedRemoteResources();
            if (remoteResources != null && remoteResources.length > 0) {
                left = new PropertyCompareRemoteResourceNode(remoteResources[0], SVNRevision.HEAD, true, null);
                if (remoteResources.length > 1) {
                    this.right = new PropertyCompareRemoteResourceNode(remoteResources[1], SVNRevision.HEAD, true, null);
                }
            }
        }
        ComparePropertiesDialog dialog = new ComparePropertiesDialog(this.getShell(), (IPropertyProvider)left, this.right);
        if (dialog.open() == 0) {
            CompareUI.openCompareEditorOnPage((CompareEditorInput)dialog.getInput(), (IWorkbenchPage)this.getTargetPage());
        }
    }

    protected boolean isEnabled() throws TeamException {
        if (this.getSelectedResources() == null || this.getSelectedResources().length == 0) {
            return true;
        }
        return super.isEnabled();
    }
}

