/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationDetectionMethodCallback<A extends Annotation>
implements ReflectionUtils.MethodCallback {
    private static final String MULTIPLE_FOUND = "Found annotation %s both on %s and %s! Make sure only one of them is annotated with it!";
    private final boolean enforceUniqueness;
    private final Class<A> annotationType;
    private Method foundMethod;
    private A annotation;

    public AnnotationDetectionMethodCallback(Class<A> annotationType) {
        this(annotationType, false);
    }

    public AnnotationDetectionMethodCallback(Class<A> annotationType, boolean enforceUniqueness) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null!");
        this.annotationType = annotationType;
        this.enforceUniqueness = enforceUniqueness;
    }

    public Method getMethod() {
        return this.foundMethod;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public boolean hasFoundAnnotation() {
        return this.annotation != null;
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        if (this.foundMethod != null && !this.enforceUniqueness) {
            return;
        }
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, this.annotationType);
        if (annotation != null) {
            if (this.foundMethod != null && this.enforceUniqueness) {
                throw new IllegalStateException(String.format(MULTIPLE_FOUND, annotation.getClass().getName(), this.foundMethod, method));
            }
            this.annotation = annotation;
            this.foundMethod = method;
        }
    }
}

