/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.domain.Auditable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.util.Assert;

class MappingAuditableBeanWrapperFactory
extends AuditableBeanWrapperFactory {
    private final MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext;
    private final Map<Class<?>, MappingAuditingMetadata> metadataCache;

    public MappingAuditableBeanWrapperFactory(MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext) {
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.mappingContext = mappingContext;
        this.metadataCache = new HashMap();
    }

    @Override
    public AuditableBeanWrapper getBeanWrapperFor(Object source) {
        if (source instanceof Auditable) {
            return super.getBeanWrapperFor(source);
        }
        Class<?> type = source.getClass();
        PersistentEntity<?, ?> entity = this.mappingContext.getPersistentEntity((PersistentProperty<?>)((Object)type));
        if (entity == null) {
            return super.getBeanWrapperFor(source);
        }
        MappingAuditingMetadata metadata = this.metadataCache.get(type);
        if (metadata == null) {
            metadata = new MappingAuditingMetadata(entity);
            this.metadataCache.put(type, metadata);
        }
        return metadata.isAuditable() ? new MappingMetadataAuditableBeanWrapper(source, metadata) : null;
    }

    static class MappingMetadataAuditableBeanWrapper
    extends AuditableBeanWrapperFactory.DateConvertingAuditableBeanWrapper {
        private final BeanWrapper<Object> wrapper;
        private final MappingAuditingMetadata metadata;

        public MappingMetadataAuditableBeanWrapper(Object target, MappingAuditingMetadata metadata) {
            Assert.notNull((Object)target, (String)"Target object must not be null!");
            Assert.notNull((Object)metadata, (String)"Auditing metadata must not be null!");
            this.wrapper = BeanWrapper.create(target, null);
            this.metadata = metadata;
        }

        @Override
        public void setCreatedBy(Object value) {
            if (this.metadata.createdByProperty != null) {
                this.wrapper.setProperty(this.metadata.createdByProperty, value);
            }
        }

        @Override
        public void setCreatedDate(Calendar value) {
            PersistentProperty property = this.metadata.createdDateProperty;
            if (property != null) {
                this.wrapper.setProperty(property, this.getDateValueToSet(value, property.getType(), property));
            }
        }

        @Override
        public void setLastModifiedBy(Object value) {
            if (this.metadata.lastModifiedByProperty != null) {
                this.wrapper.setProperty(this.metadata.lastModifiedByProperty, value);
            }
        }

        @Override
        public void setLastModifiedDate(Calendar value) {
            PersistentProperty property = this.metadata.lastModifiedDateProperty;
            if (property != null) {
                this.wrapper.setProperty(property, this.getDateValueToSet(value, property.getType(), property));
            }
        }
    }

    static class MappingAuditingMetadata {
        private final PersistentProperty<?> createdByProperty;
        private final PersistentProperty<?> createdDateProperty;
        private final PersistentProperty<?> lastModifiedByProperty;
        private final PersistentProperty<?> lastModifiedDateProperty;

        public MappingAuditingMetadata(PersistentEntity<?, ? extends PersistentProperty<?>> entity) {
            Assert.notNull(entity, (String)"PersistentEntity must not be null!");
            this.createdByProperty = entity.getPersistentProperty(CreatedBy.class);
            this.createdDateProperty = entity.getPersistentProperty(CreatedDate.class);
            this.lastModifiedByProperty = entity.getPersistentProperty(LastModifiedBy.class);
            this.lastModifiedDateProperty = entity.getPersistentProperty(LastModifiedDate.class);
        }

        public boolean isAuditable() {
            return this.createdByProperty != null || this.createdDateProperty != null || this.lastModifiedByProperty != null || this.lastModifiedDateProperty != null;
        }
    }
}

