/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.ui;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.model.AbstractAnnotationMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.beans.ui.model.metadata.IBeanMetadataContentProvider;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.metadata.MetadataUIImages;
import org.springframework.ide.eclipse.metadata.core.AspectAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.AspectMethodAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.AutowireAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.BeanMethodAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.ConfigurationAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.RequestMappingAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.TransactionalAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingBeanMetadataReference;
import org.springframework.util.StringUtils;

public class AnnotationMetadataContentProvider
implements IBeanMetadataContentProvider {
    public Object[] getChildren(Object element) {
        if (element instanceof TransactionalAnnotationMetadata || element instanceof AspectAnnotationMetadata || element instanceof ConfigurationAnnotationMetadata) {
            String className = BeansModelUtils.getBeanClass((IBean)((AbstractAnnotationMetadata)element).getBean(), null);
            IType type = JdtUtils.getJavaType((IProject)((AbstractAnnotationMetadata)element).getBean().getElementResource().getProject(), (String)className);
            if (type != null) {
                BeanMetadataNode node = new BeanMetadataNode(type.getHandleIdentifier());
                node.setLabel(String.valueOf(((AbstractAnnotationMetadata)element).getValueAsText()) + BeansUIPlugin.getLabelProvider().getText((Object)type));
                node.setImage(BeansUIPlugin.getLabelProvider().getImage((Object)type));
                node.setLocation(((AbstractAnnotationMetadata)element).getElementSourceLocation());
                HashSet<BeanMetadataNode> children = new HashSet<BeanMetadataNode>();
                for (IMethodMetadata method : ((AbstractAnnotationMetadata)element).getMethodMetaData()) {
                    BeanMetadataNode child = new BeanMetadataNode(method.getHandleIdentifier());
                    IJavaElement je = JavaCore.create((String)method.getHandleIdentifier());
                    String label = method.getValueAsText();
                    if (StringUtils.hasText((String)label)) {
                        child.setLabel(String.valueOf(label) + " " + BeansUIPlugin.getLabelProvider().getText((Object)je));
                    } else {
                        child.setLabel(BeansUIPlugin.getLabelProvider().getText((Object)je));
                    }
                    if (method instanceof AspectMethodAnnotationMetadata) {
                        AspectMethodAnnotationMetadata.Type annotationType = ((AspectMethodAnnotationMetadata)method).getType();
                        if (annotationType == AspectMethodAnnotationMetadata.Type.AFTER) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.after_advice_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.AROUND) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.around_advice_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.BEFORE) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.before_advice_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.DECLARE_ANNOTATION) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.dec_annotation_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.DECLARE_ERROR) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.dec_error_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.DECLARE_WARNING) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.dec_warning_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.DECLARE_PARENTS) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.dec_parents_obj.gif"));
                        } else if (annotationType == AspectMethodAnnotationMetadata.Type.POINTCUT) {
                            child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.pointcut_pub_obj.gif"));
                        }
                    } else if (method instanceof BeanMethodAnnotationMetadata) {
                        child.setImage(MetadataUIImages.getImage("org.springframework.ide.eclipse.metadata.configuration_bean_obj.gif"));
                    } else {
                        child.setImage(BeansUIPlugin.getLabelProvider().getImage((Object)je));
                    }
                    child.setLocation(method.getElementSourceLocation());
                    children.add(child);
                }
                node.setChildren(children.toArray());
                return new Object[]{node};
            }
        } else {
            if (element instanceof AutowireAnnotationMetadata) {
                AutowireAnnotationMetadata metadata = (AutowireAnnotationMetadata)((Object)element);
                ArrayList<BeanMetadataNode> children = new ArrayList<BeanMetadataNode>();
                for (IMethodMetadata methodMetadata : metadata.getMethodMetaData()) {
                    IJavaElement je = JavaCore.create((String)methodMetadata.getHandleIdentifier());
                    BeanMetadataNode node = new BeanMetadataNode(methodMetadata.getHandleIdentifier());
                    node.setLabel(String.valueOf(methodMetadata.getValueAsText()) + BeansUIPlugin.getLabelProvider().getText((Object)je));
                    node.setImage(BeansUIPlugin.getLabelProvider().getImage((Object)je));
                    node.setLocation(methodMetadata.getElementSourceLocation());
                    children.add(node);
                }
                return children.toArray(new Object[children.size()]);
            }
            if (element instanceof AbstractAnnotationMetadata && ((AbstractAnnotationMetadata)element).getBean() != null) {
                String className = BeansModelUtils.getBeanClass((IBean)((AbstractAnnotationMetadata)element).getBean(), null);
                IType type = JdtUtils.getJavaType((IProject)((AbstractAnnotationMetadata)element).getBean().getElementResource().getProject(), (String)className);
                if (type != null) {
                    BeanMetadataNode node = new BeanMetadataNode(type.getHandleIdentifier());
                    node.setLabel(BeansUIPlugin.getLabelProvider().getText((Object)type));
                    node.setImage(BeansUIPlugin.getLabelProvider().getImage((Object)type));
                    node.setLocation(((AbstractAnnotationMetadata)element).getElementSourceLocation());
                    return new Object[]{node};
                }
            }
        }
        return IModelElement.NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public boolean supports(Object object) {
        return object instanceof AbstractAnnotationMetadata;
    }

    public BeanMetadataReference getBeanMetadataReference(IBeanMetadata metadata, IBeansProject project) {
        if (metadata instanceof RequestMappingAnnotationMetadata) {
            return new RequestMappingBeanMetadataReference(project, metadata.getKey());
        }
        return new BeanMetadataReference(project, metadata.getKey());
    }
}

