/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.legacyconversion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.LegacyProjectChecker;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.LegacyProjectConverter;

public class LegacyProjectsJob
extends UIJob {
    private final boolean warnIfNone;
    private List<IProject> legacyProjects;
    private final boolean enableToggle;

    public LegacyProjectsJob(boolean warnIfNone, boolean enableToggle) {
        super("Legacy Maven Project Checker");
        this.warnIfNone = warnIfNone;
        this.enableToggle = enableToggle;
    }

    public LegacyProjectsJob(List<IProject> legacyProjects, boolean warnIfNone, boolean enableToggle) {
        this(warnIfNone, enableToggle);
        this.legacyProjects = legacyProjects;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        monitor.beginTask("Checking for legacy Maven projects", 100);
        IStatus status = this.doCheck(monitor, this.getDisplay().getActiveShell());
        monitor.done();
        return status;
    }

    private IStatus doCheck(IProgressMonitor monitor, Shell shell) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.legacyProjects == null) {
            this.legacyProjects = this.findLegacyProjects();
        }
        sub.worked(30);
        if (this.legacyProjects.size() > 0) {
            LegacyProjectConverter converter = new LegacyProjectConverter(this.legacyProjects);
            if (converter.askToConvert(shell, this.enableToggle)) {
                return converter.convert((IProgressMonitor)sub.newChild(70));
            }
        } else if (this.warnIfNone && !LegacyProjectChecker.NON_BLOCKING) {
            MessageDialog.openInformation((Shell)shell, (String)"No legacy projects found", (String)"No legacy projects found.");
        }
        return Status.OK_STATUS;
    }

    private List<IProject> findLegacyProjects() {
        IProject[] allProjects;
        ArrayList<IProject> legacyProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible() && project.hasNature("org.maven.ide.eclipse.maven2Nature")) {
                    legacyProjects.add(project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return legacyProjects;
    }
}

