/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.coding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class StringLiteralEqualityQuickfix
extends AbstractASTResolution {
    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartPosition) {
        return new ASTVisitor(){

            public boolean visit(InfixExpression node) {
                if (StringLiteralEqualityQuickfix.this.containsPosition(lineInfo, node.getStartPosition())) {
                    StringLiteral literal = null;
                    Expression otherOperand = null;
                    if (node.getLeftOperand() instanceof StringLiteral) {
                        literal = (StringLiteral)node.getLeftOperand();
                        otherOperand = node.getRightOperand();
                    } else if (node.getRightOperand() instanceof StringLiteral) {
                        literal = (StringLiteral)node.getRightOperand();
                        otherOperand = node.getLeftOperand();
                    } else {
                        return true;
                    }
                    MethodInvocation replacementNode = null;
                    MethodInvocation equalsInvocation = node.getAST().newMethodInvocation();
                    equalsInvocation.setName(node.getAST().newSimpleName("equals"));
                    equalsInvocation.setExpression((Expression)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)literal));
                    equalsInvocation.arguments().add(ASTNode.copySubtree((AST)node.getAST(), (ASTNode)otherOperand));
                    if (node.getOperator().equals(InfixExpression.Operator.NOT_EQUALS)) {
                        PrefixExpression prefixExpression = node.getAST().newPrefixExpression();
                        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
                        prefixExpression.setOperand((Expression)equalsInvocation);
                        replacementNode = prefixExpression;
                    } else {
                        replacementNode = equalsInvocation;
                    }
                    this.replaceNode((ASTNode)node, (ASTNode)replacementNode);
                }
                return true;
            }

            private void replaceNode(ASTNode node, ASTNode replacementNode) {
                block9: {
                    try {
                        if (node.getLocationInParent().isChildProperty()) {
                            String property = node.getLocationInParent().getId();
                            String setterMethodName = "set" + StringUtils.capitalize((String)property);
                            Class<?> testClass = node.getClass();
                            while (testClass != null) {
                                try {
                                    Method setterMethod = node.getParent().getClass().getMethod(setterMethodName, testClass);
                                    setterMethod.invoke((Object)node.getParent(), replacementNode);
                                    break block9;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    testClass = testClass.getSuperclass();
                                }
                            }
                            break block9;
                        }
                        if (node.getLocationInParent().isChildListProperty()) {
                            Method listMethod = node.getParent().getClass().getMethod(node.getLocationInParent().getId(), null);
                            List list = (List)listMethod.invoke((Object)node.getParent(), null);
                            list.set(list.indexOf(node), replacementNode);
                        }
                    }
                    catch (InvocationTargetException e) {
                        CheckstyleLog.log((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        CheckstyleLog.log((Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        CheckstyleLog.log((Throwable)e);
                    }
                }
            }
        };
    }

    public String getDescription() {
        return Messages.StringLiteralEqualityQuickfix_description;
    }

    public String getLabel() {
        return Messages.StringLiteralEqualityQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_CHANGE);
    }
}

