/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.PropertyNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.DocumentUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.Provider;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class SpringPropertiesReconcileEngine
implements IReconcileEngine {
    private Provider<FuzzyMap<PropertyInfo>> fIndexProvider;
    private TypeUtil typeUtil;

    public SpringPropertiesReconcileEngine(Provider<FuzzyMap<PropertyInfo>> provider, TypeUtil typeUtil) {
        this.fIndexProvider = provider;
        this.typeUtil = typeUtil;
    }

    @Override
    public void reconcile(IDocument doc, IProblemCollector problemCollector, IProgressMonitor mon) {
        block15: {
            FuzzyMap<PropertyInfo> index = this.getIndex();
            if (index == null || index.isEmpty()) {
                return;
            }
            problemCollector.beginCollecting();
            try {
                try {
                    ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___pf_partitioning", (int)0, (int)doc.getLength(), (boolean)true);
                    if (regions == null || regions.length <= 0) break block15;
                    mon.beginTask("Reconciling Spring Properties", regions.length);
                    int i = 0;
                    while (i < regions.length) {
                        ITypedRegion r = regions[i];
                        try {
                            String type = r.getType();
                            if ("__dftl_partition_content_type".equals(type)) {
                                String fullName = doc.get(r.getOffset(), r.getLength()).trim();
                                ITypedRegion trimmedRegion = r;
                                if (fullName.length() < r.getLength()) {
                                    String paddedName = doc.get(r.getOffset(), r.getLength());
                                    int start = paddedName.indexOf(fullName);
                                    trimmedRegion = new Region(r.getOffset() + start, fullName.length());
                                }
                                if (!fullName.isEmpty() || this.isAssigned(doc, (IRegion)r)) {
                                    PropertyInfo validProperty = SpringPropertiesCompletionEngine.findLongestValidProperty(index, fullName);
                                    if (validProperty != null) {
                                        PropertyNavigator navigator = new PropertyNavigator(doc, problemCollector, this.typeUtil, (IRegion)trimmedRegion);
                                        int offset = validProperty.getId().length() + trimmedRegion.getOffset();
                                        Type valueType = navigator.navigate(offset, TypeParser.parse(validProperty.getType()));
                                        if (valueType != null) {
                                            this.reconcileType(doc, valueType, regions, i, problemCollector);
                                        }
                                    } else {
                                        PropertyInfo similarEntry = index.findLongestCommonPrefixEntry(fullName);
                                        String validPrefix = StringUtil.commonPrefix((String)similarEntry.getId(), (String)fullName);
                                        problemCollector.accept(SpringPropertyProblem.warning("'" + fullName + "' is an unknown property." + this.suggestSimilar(similarEntry, validPrefix, fullName), trimmedRegion.getOffset() + validPrefix.length(), trimmedRegion.getLength() - validPrefix.length()));
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            SpringPropertiesEditorPlugin.log(e);
                        }
                        ++i;
                    }
                }
                catch (Throwable e2) {
                    SpringPropertiesEditorPlugin.log(e2);
                    problemCollector.endCollecting();
                }
            }
            finally {
                problemCollector.endCollecting();
            }
        }
    }

    private FuzzyMap<PropertyInfo> getIndex() {
        return this.fIndexProvider.get();
    }

    private void reconcileType(IDocument doc, Type expectType, ITypedRegion[] regions, int i, IProblemCollector problems) {
        TypeUtil.ValueParser parser = this.typeUtil.getValueParser(expectType);
        if (parser != null) {
            String escapedValue = this.getAssignedValue(doc, regions, i);
            ITypedRegion errorRegion = null;
            if (escapedValue == null) {
                int charPos = DocumentUtil.lastNonWhitespaceCharOfRegion(doc, (IRegion)regions[i]);
                if (charPos >= 0) {
                    errorRegion = new Region(charPos, 1);
                }
            } else {
                try {
                    String valueStr = PropertiesFileEscapes.unescape((String)escapedValue.trim());
                    if (!valueStr.contains("${")) {
                        parser.parse(valueStr);
                    }
                }
                catch (Exception exception) {
                    errorRegion = regions[i + 1];
                    try {
                        int endChar = DocumentUtil.lastNonWhitespaceCharOfRegion(doc, (IRegion)errorRegion);
                        if (endChar >= 0) {
                            char assign;
                            int startChar = DocumentUtil.firstNonWhitespaceCharOfRegion(doc, (IRegion)errorRegion);
                            if (startChar >= 0 && SpringPropertiesCompletionEngine.isAssign(assign = doc.getChar(startChar))) {
                                startChar = DocumentUtil.firstNonWhitespaceCharOfRegion(doc, (IRegion)new Region(startChar + 1, endChar - startChar));
                            }
                            if (startChar >= 0) {
                                errorRegion = new Region(startChar, endChar - startChar + 1);
                            }
                        }
                    }
                    catch (Exception e2) {
                        SpringPropertiesEditorPlugin.log(e2);
                    }
                }
            }
            if (errorRegion != null) {
                problems.accept(SpringPropertyProblem.error("Expecting '" + this.typeUtil.niceTypeName(expectType) + "'", errorRegion.getOffset(), errorRegion.getLength()));
            }
        }
    }

    private String getAssignedValue(IDocument doc, ITypedRegion[] regions, int i) {
        try {
            ITypedRegion valueRegion;
            int valueRegionIndex = i + 1;
            if (valueRegionIndex < regions.length && (valueRegion = regions[valueRegionIndex]).getType() == "__pf_roperty_value") {
                char assignment;
                String regionText = doc.get(valueRegion.getOffset(), valueRegion.getLength());
                if (!(regionText = regionText.trim()).isEmpty() && SpringPropertiesCompletionEngine.isAssign(assignment = regionText.charAt(0))) {
                    regionText = regionText.substring(1).trim();
                }
                return regionText;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return null;
    }

    private String suggestSimilar(PropertyInfo similarEntry, String validPrefix, String fullName) {
        int matchedChars = validPrefix.length();
        int wrongChars = fullName.length() - matchedChars;
        if (wrongChars < matchedChars) {
            return " Did you mean '" + similarEntry.getId() + "'?";
        }
        return "";
    }

    private boolean isAssigned(IDocument doc, IRegion r) {
        try {
            char c = doc.getChar(r.getOffset() + r.getLength());
            return SpringPropertiesCompletionEngine.isAssign(c);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public static interface IProblemCollector {
        public static final IProblemCollector NULL = new IProblemCollector(){

            @Override
            public void beginCollecting() {
            }

            @Override
            public void endCollecting() {
            }

            @Override
            public void accept(SpringPropertyProblem springPropertyProblem) {
            }
        };

        public void beginCollecting();

        public void endCollecting();

        public void accept(SpringPropertyProblem var1);
    }
}

