/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.gradle;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaCore;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.util.AptUtils;
import org.springsource.ide.eclipse.gradle.core.GradleCore;
import org.springsource.ide.eclipse.gradle.core.api.IProjectConfigurationRequest;
import org.springsource.ide.eclipse.gradle.core.api.IProjectConfigurator;

public class EnableJdtAptGradleProjectConfigurator
implements IProjectConfigurator {
    public void configure(IProjectConfigurationRequest request, IProgressMonitor monitor) throws Exception {
        if (this.isJavaProject(request.getProject()) && this.isPreferenceEnabled(request.getProject()) && this.shouldConfigureApt(request.getGradleModel())) {
            AptUtils.configureApt(JavaCore.create((IProject)request.getProject()));
        }
    }

    protected boolean shouldConfigureApt(EclipseProject gradleModel) {
        return AptUtils.isAptEnabled(GradleCore.create((HierarchicalEclipseProject)gradleModel).getJavaProject()) || this.shouldEnableApt(gradleModel);
    }

    private boolean isJavaProject(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            SpringPropertiesEditorPlugin.log(e);
            return false;
        }
    }

    private boolean isPreferenceEnabled(IProject p) {
        return Platform.getPreferencesService().getBoolean("org.springframework.ide.eclipse.boot.properties.editor", "org.springframework.ide.eclipse.apt.autoconfigure.gradle", true, null);
    }

    protected boolean shouldEnableApt(EclipseProject eclipseProject) {
        for (ExternalDependency d : eclipseProject.getClasspath()) {
            GradleModuleVersion a = d.getGradleModuleVersion();
            if (a == null || !"org.springframework.boot".equals(a.getGroup()) || !"spring-boot-configuration-processor".equals(a.getName())) continue;
            return true;
        }
        return false;
    }
}

