/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.navigator.BeansNavigatorSorter;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.ui.properties.BeansConfigContentProvider;
import org.springframework.ide.eclipse.webflow.ui.properties.BeansConfigLabelProvider;

public class WebflowConfigDialog
extends Dialog {
    private static final int BEANS_CONFIG_LIST_VIEWER_HEIGHT = 150;
    private static final int LIST_VIEWER_WIDTH = 340;
    private CheckboxTableViewer beansConfigSetViewer;
    private Text nameText;
    private Button okButton;
    private Label errorLabel;
    private String title;
    private IProject project;
    private Set<IModelElement> beansConfig;
    private List<String> config;
    private IFile file;

    public WebflowConfigDialog(Shell parent, IProject project, Set<IModelElement> beansConfig, List<String> config, IFile file) {
        super(parent);
        this.project = project;
        this.config = config;
        this.beansConfig = beansConfig;
        this.title = "Link to Spring configs";
        String name = config.get(0);
        if (name == null) {
            int i = file.getName().lastIndexOf(46);
            if (i > 0) {
                name = file.getName().substring(0, i);
            }
            config.add(0, name);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Specify a flow id");
        this.nameText = new Text(composite, 2052);
        if (this.config != null && this.config.size() > 0 && this.config.get(0) != null) {
            this.nameText.setText(this.config.get(0));
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebflowConfigDialog.this.validateName();
            }
        });
        Label beansLabel = new Label(composite, 0);
        beansLabel.setText("Link Spring Bean Config and Config Sets");
        this.beansConfigSetViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 150;
        this.beansConfigSetViewer.getTable().setLayoutData((Object)gd);
        this.beansConfigSetViewer.setContentProvider((IContentProvider)new BeansConfigContentProvider(this.createBeansConfigList()));
        this.beansConfigSetViewer.setLabelProvider((IBaseLabelProvider)new BeansConfigLabelProvider());
        this.beansConfigSetViewer.setInput((Object)this);
        if (this.beansConfig != null) {
            this.beansConfigSetViewer.setCheckedElements(this.beansConfig.toArray());
        }
        this.beansConfigSetViewer.setSorter((ViewerSorter)new BeansNavigatorSorter());
        this.errorLabel = new Label(composite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setForeground(JFaceColors.getErrorText((Display)parent.getDisplay()));
        this.errorLabel.setBackground(JFaceColors.getErrorBackground((Display)parent.getDisplay()));
        WebflowConfigDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Button createCheckBox(Composite group, String labelText) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        Button button = new Button(group, 32);
        Label label = new Label(group, 0);
        label.setText(labelText);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            List<Object> configs = Arrays.asList(this.beansConfigSetViewer.getCheckedElements());
            this.beansConfig.clear();
            this.beansConfig.addAll(configs);
            this.config.add(0, this.nameText.getText());
        }
        super.buttonPressed(buttonId);
    }

    private Set<IModelElement> createBeansConfigList() {
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(this.project);
        HashSet<IModelElement> elements = new HashSet<IModelElement>();
        elements.addAll(beansProject.getConfigs());
        elements.addAll(beansProject.getConfigSets());
        return elements;
    }

    private void validateName() {
        boolean isEnabled = true;
        String name = this.nameText.getText();
        if (name == null || name.trim().length() == 0) {
            this.errorLabel.setText("Please specify a valid flow id");
            isEnabled = false;
        } else {
            IWebflowProject wp = Activator.getModel().getProject(this.project);
            for (IWebflowConfig config : wp.getConfigs()) {
                if (!name.equals(config.getName()) || config.getResource().equals((Object)this.file)) continue;
                this.errorLabel.setText("Flow id already in use in this project");
                isEnabled = false;
            }
        }
        this.okButton.setEnabled(isEnabled);
        this.errorLabel.getParent().update();
    }

    public String getName() {
        return this.nameText.getText();
    }
}

