/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowNavigatorDropAdapter
extends CommonDropAdapterAssistant {
    private IModelElement getWebflowModelElementFromTarget(IResource resource, Object target) {
        if (target instanceof IWorkspaceRoot) {
            return Activator.getModel().getProject(resource.getProject());
        }
        if (target instanceof ISpringProject) {
            return Activator.getModel().getProject(((ISpringProject)target).getProject());
        }
        if (target instanceof IModelElement) {
            return (IModelElement)target;
        }
        return null;
    }

    private IProject getProject(IModelElement modelElement) {
        if (modelElement instanceof IWebflowProject) {
            return ((IWebflowProject)modelElement).getProject();
        }
        if (modelElement instanceof IWebflowConfig) {
            return ((IWebflowConfig)modelElement).getElementResource().getProject();
        }
        return null;
    }

    private IResource getResourceFromDropTarget(DropTargetEvent dropTargetEvent) {
        Object object = dropTargetEvent.data;
        if (object instanceof ITreeSelection) {
            object = ((ITreeSelection)object).getFirstElement();
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        IResource resource = this.getResourceFromDropTarget(dropTargetEvent);
        if (SpringCoreUtils.isSpringProject((IResource)resource) && resource instanceof IFile) {
            IFile file = (IFile)resource;
            IModelElement parent = this.getWebflowModelElementFromTarget(resource, target);
            if (parent instanceof WebflowProject) {
                WebflowProject webflowProject = (WebflowProject)parent;
                IProject project = this.getProject(parent);
                if (resource.getProject().equals((Object)project) && webflowProject.getConfig(file) == null) {
                    List configs = webflowProject.getConfigs();
                    WebflowConfig config = new WebflowConfig((IWebflowProject)webflowProject);
                    config.setResource(file);
                    configs.add(config);
                    webflowProject.setConfigs(configs);
                    return Status.OK_STATUS;
                }
            } else if (parent instanceof WebflowConfig) {
                WebflowConfig webflowConfig = (WebflowConfig)parent;
                IProject project = this.getProject(parent);
                WebflowProject webflowProject = (WebflowProject)Activator.getModel().getProject(project);
                if (!webflowProject.isUpdatable()) {
                    return Status.CANCEL_STATUS;
                }
                IBeansConfig beansElement = BeansCorePlugin.getModel().getConfig(file);
                if (beansElement != null && resource.getProject().equals((Object)project) && !webflowConfig.getBeansConfigs().contains(beansElement)) {
                    Set beanElements = webflowConfig.getBeansConfigs();
                    beanElements.add(beansElement);
                    webflowConfig.setBeansConfigs(beanElements);
                    webflowProject.saveDescription();
                    return Status.OK_STATUS;
                }
            }
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (operation == 1) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

