/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.ui;

import com.atlassian.connector.eclipse.internal.branding.ui.AtlassianBrandingPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public final class AtlassianLogo {
    private static ImageRegistry imageRegistry;
    private static final URL BASE_URL;
    public static final ImageDescriptor ATLASSIAN_LOGO;

    static {
        BASE_URL = AtlassianBrandingPlugin.getDefault().getBundle().getEntry("/icons/");
        ATLASSIAN_LOGO = AtlassianLogo.create("misc", "Atlassian.png");
    }

    private AtlassianLogo() {
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)AtlassianLogo.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(BASE_URL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry registry = AtlassianLogo.getImageRegistry();
        Image image = registry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            registry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

