/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceQueryHintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceNamedNativeQueryAnnotation
extends SourceQueryAnnotation
implements NamedNativeQueryAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQuery");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQueries");
    DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter = this.buildQueryDeclarationAdapter();
    AnnotationElementAdapter<String> queryAdapter = this.buildQueryAdapter();
    String query;
    List<TextRange> queryTextRanges;
    private DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter = this.buildResultClassDeclarationAdapter();
    private AnnotationElementAdapter<String> resultClassAdapter = this.buildResultClassAdapter();
    private String resultClass;
    private TextRange resultClassTextRange;
    private String fullyQualifiedResultClassName;
    private boolean fqResultClassNameStale = true;
    private DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultSetMapping;
    private TextRange resultSetMappingTextRange;

    public static SourceNamedNativeQueryAnnotation buildSourceNamedNativeQueryAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceNamedNativeQueryAnnotation.buildNamedNativeQueryDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceNamedNativeQueryAnnotation.buildNamedNativeQueryAnnotationAdapter(element, idaa);
        return new SourceNamedNativeQueryAnnotation(parent, element, idaa, iaa);
    }

    private SourceNamedNativeQueryAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceModel)parent, element, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter((DeclarationAnnotationAdapter)daa);
        this.resultSetMappingAdapter = this.buildResultSetMappingAdapter();
    }

    public String getAnnotationName() {
        return "javax.persistence.NamedNativeQuery";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.query = this.buildQuery(astAnnotation);
        this.queryTextRanges = this.buildQueryTextRanges(astAnnotation);
        this.resultClass = this.buildResultClass(astAnnotation);
        this.resultClassTextRange = this.buildResultClassTextRange(astAnnotation);
        this.resultSetMapping = this.buildResultSetMapping(astAnnotation);
        this.resultSetMappingTextRange = this.buildResultSetMappingTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncQuery(this.buildQuery(astAnnotation));
        this.queryTextRanges = this.buildQueryTextRanges(astAnnotation);
        this.syncResultClass(this.buildResultClass(astAnnotation));
        this.resultClassTextRange = this.buildResultClassTextRange(astAnnotation);
        this.syncResultSetMapping(this.buildResultSetMapping(astAnnotation));
        this.resultSetMappingTextRange = this.buildResultSetMappingTextRange(astAnnotation);
    }

    @Override
    public String getNameElementName() {
        return "name";
    }

    @Override
    public String getHintsElementName() {
        return "hints";
    }

    @Override
    public QueryHintAnnotation buildHint(int index) {
        return SourceQueryHintAnnotation.buildNamedNativeQueryQueryHint((JavaResourceModel)this, this.annotatedElement, this.daa, index);
    }

    String getQueryElementName() {
        return "query";
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        if (ObjectTools.notEquals((Object)this.query, (Object)query)) {
            this.query = query;
            this.queryAdapter.setValue((Object)query);
        }
    }

    private void syncQuery(String annotationQuery) {
        String old = this.query;
        this.query = annotationQuery;
        this.firePropertyChanged("query", old, annotationQuery);
    }

    private String buildQuery(Annotation astAnnotation) {
        return (String)this.queryAdapter.getValue(astAnnotation);
    }

    @Override
    public List<TextRange> getQueryTextRanges() {
        return this.queryTextRanges;
    }

    private List<TextRange> buildQueryTextRanges(Annotation astAnnotation) {
        return this.getElementTextRanges(this.queryDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildQueryDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)this.getQueryElementName());
    }

    private AnnotationElementAdapter<String> buildQueryAdapter() {
        return this.buildStringElementAdapter(this.queryDeclarationAdapter);
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public void setResultClass(String resultClass) {
        if (ObjectTools.notEquals((Object)this.resultClass, (Object)resultClass)) {
            this.resultClass = resultClass;
            this.fqResultClassNameStale = true;
            this.resultClassAdapter.setValue((Object)resultClass);
        }
    }

    private void syncResultClass(String astResultClass) {
        if (ObjectTools.notEquals((Object)this.resultClass, (Object)astResultClass)) {
            this.syncResultClass_(astResultClass);
        }
    }

    private void syncResultClass_(String astResultClass) {
        String old = this.resultClass;
        this.resultClass = astResultClass;
        this.fqResultClassNameStale = true;
        this.firePropertyChanged("resultClass", old, astResultClass);
    }

    private String buildResultClass(Annotation astAnnotation) {
        return (String)this.resultClassAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getResultClassTextRange() {
        return this.resultClassTextRange;
    }

    private TextRange buildResultClassTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.resultClassDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultClassDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    private AnnotationElementAdapter<String> buildResultClassAdapter() {
        return this.buildStringElementAdapter(this.resultClassDeclarationAdapter);
    }

    @Override
    public String getFullyQualifiedResultClassName() {
        if (this.fqResultClassNameStale) {
            this.fullyQualifiedResultClassName = this.buildFullyQualifiedResultClassName();
            this.fqResultClassNameStale = false;
        }
        return this.fullyQualifiedResultClassName;
    }

    private String buildFullyQualifiedResultClassName() {
        return this.resultClass == null ? null : this.buildFullyQualifiedResultClassName_();
    }

    private String buildFullyQualifiedResultClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.resultClassAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public void setResultSetMapping(String resultSetMapping) {
        if (ObjectTools.notEquals((Object)this.resultSetMapping, (Object)resultSetMapping)) {
            this.resultSetMapping = resultSetMapping;
            this.resultSetMappingAdapter.setValue((Object)resultSetMapping);
        }
    }

    private void syncResultSetMapping(String astResultSetMapping) {
        String old = this.resultSetMapping;
        this.resultSetMapping = astResultSetMapping;
        this.firePropertyChanged("resultSetMapping", old, astResultSetMapping);
    }

    private String buildResultSetMapping(Annotation astAnnotation) {
        return (String)this.resultSetMappingAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getResultSetMappingTextRange() {
        return this.resultSetMappingTextRange;
    }

    private TextRange buildResultSetMappingTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultSetMappingAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"resultSetMapping");
    }

    private AnnotationElementAdapter<String> buildResultSetMappingAdapter() {
        return this.buildStringElementAdapter(this.resultSetMappingDeclarationAdapter);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.query == null && this.resultClass == null && this.resultSetMapping == null;
    }

    private static IndexedAnnotationAdapter buildNamedNativeQueryAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedNativeQueryDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "javax.persistence.NamedNativeQuery");
        return idaa;
    }
}

