/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractPrimaryKeyValidator;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityPrimaryKeyValidator
extends AbstractPrimaryKeyValidator {
    protected AbstractEntityPrimaryKeyValidator(Entity entity) {
        super(entity);
    }

    protected Entity entity() {
        return (Entity)this.typeMapping();
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        if (!this.entity().isRootEntity()) {
            this.validatePrimaryKeyForNonRoot(messages, reporter);
        } else {
            this.validatePrimaryKeyForRoot(messages, reporter);
        }
        return true;
    }

    protected void validatePrimaryKeyForNonRoot(List<IMessage> messages, IReporter reporter) {
        this.validateNonRootEntityDoesNotSpecifyIdClass(messages, reporter);
        this.validateNonRootEntityDoesNotSpecifyPrimaryKeyAttributes(messages, reporter);
    }

    protected void validatePrimaryKeyForRoot(List<IMessage> messages, IReporter reporter) {
        this.validatePrimaryKeyIsNotRedefined(messages, reporter);
        this.validateIdClassIsUsedIfNecessary(messages, reporter);
        if (!this.definesPrimaryKey(this.typeMapping())) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.entity().getResource(), (TextRange)this.entity().getValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.ENTITY_NO_PK));
        }
        this.validateOneOfIdClassOrEmbeddedIdIsUsed(messages, reporter);
        this.validateOneEmbeddedId(messages, reporter);
        this.validateOneOfEmbeddedOrIdIsUsed(messages, reporter);
        this.validateMapsIdMappings(messages, reporter);
        if (this.declaresIdClassInHierarchy()) {
            this.validateIdClass(this.idClassReference().getIdClass(), messages, reporter);
        }
    }

    protected void validateNonRootEntityDoesNotSpecifyIdClass(List<IMessage> messages, IReporter reporter) {
        if (this.declaresIdClassLocally()) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.entity().getResource(), (TextRange)this.getIdClassRefValidationTextRange(), (ValidationMessage)JptJpaCoreValidationMessages.ENTITY_NON_ROOT_ID_CLASS_SPECIFIED));
        }
    }

    protected void validateNonRootEntityDoesNotSpecifyPrimaryKeyAttributes(List<IMessage> messages, IReporter reporter) {
        for (AttributeMapping each : this.getPrimaryKeyMappingsDefinedLocally(this.typeMapping())) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)each.getResource(), (TextRange)this.getAttributeMappingTextRange(each), (ValidationMessage)JptJpaCoreValidationMessages.ENTITY_NON_ROOT_ID_ATTRIBUTE_SPECIFIED));
        }
    }

    @Override
    protected TextRange getIdClassRefValidationTextRange() {
        return this.declaresIdClassLocally() ? super.getIdClassRefValidationTextRange() : this.typeMapping().getValidationTextRange();
    }
}

