/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericTypeMappingValidator;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTypeMapping<A extends Annotation>
extends AbstractJavaContextModel<JavaPersistentType>
implements JavaTypeMapping {
    protected final A mappingAnnotation;

    protected AbstractJavaTypeMapping(JavaPersistentType parent, A mappingAnnotation) {
        super(parent);
        this.mappingAnnotation = mappingAnnotation;
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return (JavaPersistentType)this.parent;
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return this.getPersistentType().getJavaResourceType();
    }

    @Override
    public String getName() {
        return this.getPersistentType().getName();
    }

    public A getMappingAnnotation() {
        return this.mappingAnnotation;
    }

    @Override
    public boolean attributeIsDerivedId(String attributeName) {
        return TypeMappingTools.attributeIsDerivedId(this, attributeName);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public Iterable<Table> getAssociatedTables() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<Table> getAllAssociatedTables() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getAllAssociatedTableNames() {
        return EmptyIterable.instance();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
        return null;
    }

    @Override
    public Iterable<JavaAttributeMapping> getAttributeMappings() {
        return IterableTools.downCast((ListIterable)IterableTools.transform(this.getPersistentType().getAttributes(), PersistentAttribute.MAPPING_TRANSFORMER));
    }

    @Override
    public Iterable<JavaAttributeMapping> getAttributeMappings(String mappingKey) {
        return IterableTools.filter(this.getAttributeMappings(), (Predicate)new AttributeMapping.KeyEquals(mappingKey));
    }

    @Override
    public Iterable<AttributeMapping> getAllAttributeMappings() {
        return IterableTools.transform(this.getPersistentType().getAllAttributes(), PersistentAttribute.MAPPING_TRANSFORMER);
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(String mappingKey) {
        return IterableTools.filter(this.getAllAttributeMappings(), (Predicate)new AttributeMapping.KeyEquals(mappingKey));
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterable<AttributeMapping> getNonTransientAttributeMappings() {
        return new FilteringIterable(this.getAllAttributeMappings(), AttributeMapping.IS_NOT_TRANSIENT);
    }

    @Override
    public Iterable<AttributeMapping> getIdAttributeMappings() {
        return IterableTools.filter(this.getAllAttributeMappings(), (Predicate)new TypeMapping.MappingIsIdMapping());
    }

    @Override
    public AttributeMapping getIdAttributeMapping() {
        Iterable<AttributeMapping> idMappings = this.getIdAttributeMappings();
        if (IterableTools.size(idMappings) == 1) {
            return (AttributeMapping)IterableTools.get(idMappings, (int)0);
        }
        return null;
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return IterableTools.children(this.getAttributeMappings(), AttributeMapping.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAttributeNames() {
        return IterableTools.children((Iterable)this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER);
    }

    @Override
    public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            SpecifiedColumn column = attributeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return IterableTools.children(this.getAttributeMappings(), AttributeMapping.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAssociationNames() {
        return IterableTools.children((Iterable)this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER);
    }

    @Override
    public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            SpecifiedRelationship relationship = attributeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        return null;
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return IterableTools.children(this.getAttributeMappings(), AttributeMapping.GENERATORS_TRANSFORMER);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateType(messages, reporter);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter) {
        if (this.getJavaResourceType() != null) {
            this.buildTypeMappingValidator().validate(messages, reporter);
        }
    }

    protected JpaValidator buildTypeMappingValidator() {
        return new GenericTypeMappingValidator(this);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getPersistenceUnit().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.mappingAnnotation.getTextRange();
        return textRange != null ? textRange : this.getPersistentType().getValidationTextRange();
    }
}

