/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaAnnotationDefinitionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaAnnotationProvider
implements AnnotationProvider {
    private final Iterable<JpaAnnotationDefinitionProvider> annotationDefinitionProviders;

    public JpaAnnotationProvider(JpaAnnotationDefinitionProvider ... annotationDefinitionProviders) {
        this.annotationDefinitionProviders = IterableTools.iterable((Object[])annotationDefinitionProviders);
    }

    public Iterable<String> getAnnotationNames() {
        return IterableTools.transform(this.getAnnotationDefinitions(), (Transformer)AnnotationDefinition.ANNOTATION_NAME_TRANSFORMER);
    }

    public Iterable<String> getContainerAnnotationNames() {
        return IterableTools.transform(this.getNestableAnnotationDefinitions(), (Transformer)NestableAnnotationDefinition.CONTAINER_ANNOTATION_NAME_TRANSFORMER);
    }

    public Iterable<String> getNestableAnnotationNames() {
        return IterableTools.transform(this.getNestableAnnotationDefinitions(), (Transformer)NestableAnnotationDefinition.NESTABLE_ANNOTATION_NAME_TRANSFORMER);
    }

    protected Iterable<AnnotationDefinition> getAnnotationDefinitions() {
        return IterableTools.children(this.annotationDefinitionProviders, JpaAnnotationDefinitionProvider.ANNOTATION_DEFINITIONS_TRANSFORMER);
    }

    protected Iterable<NestableAnnotationDefinition> getNestableAnnotationDefinitions() {
        return IterableTools.children(this.annotationDefinitionProviders, JpaAnnotationDefinitionProvider.NESTABLE_ANNOTATION_DEFINITIONS_TRANSFORMER);
    }

    public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, String annotationName) {
        return this.getAnnotationDefinition(annotationName).buildAnnotation(parent, element);
    }

    public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent, String annotationName) {
        return this.getAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation) {
        return this.getAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation(parent, jdtAnnotation);
    }

    public NestableAnnotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation, int index) {
        return this.getNestableAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation(parent, jdtAnnotation, index);
    }

    protected AnnotationDefinition getAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = this.selectAnnotationDefinition(this.getAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    protected NestableAnnotationDefinition getNestableAnnotationDefinition(String annotationName) {
        NestableAnnotationDefinition annotationDefinition = this.selectNestableAnnotationDefinition(this.getNestableAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported nsetable annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    public NestableAnnotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, String annotationName, int index) {
        return this.getNestableAnnotationDefinition(annotationName).buildAnnotation(parent, element, index);
    }

    public String getNestableAnnotationName(String containerAnnotationName) {
        return this.getNestableAnnotationDefinitionForContainer(containerAnnotationName).getNestableAnnotationName();
    }

    public String getContainerAnnotationName(String nestableAnnotationName) {
        return this.getNestableAnnotationDefinition(nestableAnnotationName).getContainerAnnotationName();
    }

    public String getNestableElementName(String nestableAnnotationName) {
        return this.getNestableAnnotationDefinition(nestableAnnotationName).getElementName();
    }

    private NestableAnnotationDefinition getNestableAnnotationDefinitionForContainer(String containerAnnotationName) {
        for (NestableAnnotationDefinition nestableAnnotationDefinition : this.getNestableAnnotationDefinitions()) {
            if (!nestableAnnotationDefinition.getContainerAnnotationName().equals(containerAnnotationName)) continue;
            return nestableAnnotationDefinition;
        }
        return null;
    }

    protected AnnotationDefinition selectAnnotationDefinition(Iterable<AnnotationDefinition> annotationDefinitions, String annotationName) {
        for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
            if (!annotationDefinition.getAnnotationName().equals(annotationName)) continue;
            return annotationDefinition;
        }
        return null;
    }

    protected NestableAnnotationDefinition selectNestableAnnotationDefinition(Iterable<NestableAnnotationDefinition> annotationDefinitions, String annotationName) {
        for (NestableAnnotationDefinition annotationDefinition : annotationDefinitions) {
            if (!annotationDefinition.getNestableAnnotationName().equals(annotationName)) continue;
            return annotationDefinition;
        }
        return null;
    }
}

