/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.maven.apt.MavenJdtAptPlugin;
import org.jboss.tools.maven.apt.preferences.AnnotationProcessingMode;
import org.jboss.tools.maven.apt.preferences.IPreferencesManager;
import org.jboss.tools.maven.apt.ui.MavenJdtAptUIPlugin;
import org.jboss.tools.maven.apt.ui.preferences.PreferenceMessages;
import org.jboss.tools.maven.apt.ui.preferences.xpl.PropertyAndPreferencePage;

public class AnnotationProcessingSettingsPage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.jboss.tools.maven.apt.ui.preferences.AnnotationProcessingPreferencePage";
    public static final String PROP_ID = "org.jboss.tools.maven.apt.ui.propertyPages.AnnotationProcessingPropertyPage";
    private Button disableAptButton;
    private Button useJdtAptButton;
    private Button mavenExecutionButton;
    private IPreferencesManager preferencesManager;
    private AnnotationProcessingMode annotationProcessingMode;
    private AnnotationProcessingMode initialAnnotationProcessingMode;
    private boolean hasConfigChanged = false;
    private Group modeGroup;

    public AnnotationProcessingSettingsPage() {
        this.setPreferenceStore(MavenJdtAptUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(PreferenceMessages.AnnotationProcessingSettingsPage_Title);
        this.preferencesManager = MavenJdtAptPlugin.getDefault().getPreferencesManager();
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        this.annotationProcessingMode = this.initialAnnotationProcessingMode = this.preferencesManager.getAnnotationProcessorMode(this.getProject());
        this.createModeGroup(composite);
        return composite;
    }

    private void createModeGroup(Composite composite) {
        this.modeGroup = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        this.modeGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this.modeGroup.setLayoutData((Object)data);
        this.useJdtAptButton = this.createRadioButton((Composite)this.modeGroup, PreferenceMessages.AnnotationProcessingSettingsPage_Jdt_Apt_Mode_Label, AnnotationProcessingMode.jdt_apt);
        this.mavenExecutionButton = this.createRadioButton((Composite)this.modeGroup, PreferenceMessages.AnnotationProcessingSettingsPage_Maven_Execution_Mode, AnnotationProcessingMode.maven_execution);
        this.disableAptButton = this.createRadioButton((Composite)this.modeGroup, PreferenceMessages.AnnotationProcessingSettingsPage_Disabled_Mode_Label, AnnotationProcessingMode.disabled);
        this.resetModeButtons();
    }

    private String getModeGroupTitle() {
        StringBuilder title = new StringBuilder(PreferenceMessages.AnnotationProcessingSettingsPage_Select_Annotation_Processing_Mode);
        IProject p = this.getProject();
        AnnotationProcessingMode pomMode = this.preferencesManager.getPomAnnotationProcessorMode(p);
        if (p != null && !this.useProjectSettings() && pomMode != null) {
            title.append(" (<m2e.apt.activation> currently set in pom.xml)");
        }
        return title.toString();
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.preferencesManager.hasSpecificProjectSettings(project);
    }

    @Override
    protected String getPreferencePageID() {
        return PREF_ID;
    }

    @Override
    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected Button createRadioButton(Composite parent, String label, final AnnotationProcessingMode newMode) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!newMode.equals((Object)AnnotationProcessingSettingsPage.this.annotationProcessingMode)) {
                    AnnotationProcessingSettingsPage.this.annotationProcessingMode = newMode;
                    AnnotationProcessingSettingsPage.this.resetModeButtons();
                    AnnotationProcessingSettingsPage.this.hasConfigChanged = true;
                }
            }
        });
        return button;
    }

    public boolean performOk() {
        IProject project = this.getProject();
        boolean useProjectSettings = this.useProjectSettings();
        if (!useProjectSettings) {
            this.preferencesManager.clearSpecificSettings(project);
            project = null;
        }
        if (this.hasConfigChanged) {
            this.preferencesManager.setAnnotationProcessorMode(project, this.annotationProcessingMode);
            boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Maven Annotation Processing Settings", (String)"m2e-apt settings have changed. Do you want to update project configuration?");
            if (res) {
                this.updateImpactedProjects();
                this.hasConfigChanged = false;
            }
        }
        return super.performOk();
    }

    @Override
    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        this.annotationProcessingMode = null;
        if (!useProjectSpecificSettings && this.getProject() != null) {
            this.annotationProcessingMode = this.preferencesManager.getPomAnnotationProcessorMode(this.getProject());
        }
        if (this.annotationProcessingMode == null) {
            this.annotationProcessingMode = this.preferencesManager.getAnnotationProcessorMode(this.getProject());
        }
        this.resetModeButtons();
        this.hasConfigChanged = true;
    }

    private void resetModeButtons() {
        this.useJdtAptButton.setSelection(this.annotationProcessingMode == AnnotationProcessingMode.jdt_apt);
        this.disableAptButton.setSelection(this.annotationProcessingMode == AnnotationProcessingMode.disabled);
        this.mavenExecutionButton.setSelection(this.annotationProcessingMode == AnnotationProcessingMode.maven_execution);
        this.modeGroup.setText(this.getModeGroupTitle());
    }

    private void updateImpactedProjects() {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        final List<IMavenProjectFacade> facades = this.getImpactedProjects(projectManager);
        if (facades.isEmpty()) {
            return;
        }
        final IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        WorkspaceJob job = new WorkspaceJob("Updating maven projects"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating Maven projects", (int)100);
                    SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(5), (int)(facades.size() * 100));
                    for (IMavenProjectFacade facade : facades) {
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProject project = facade.getProject();
                        subProgress.subTask("Updating configuration for " + project.getName());
                        configurationManager.updateProjectConfiguration(project, (IProgressMonitor)subProgress);
                    }
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(configurationManager.getRule());
        job.schedule();
    }

    private List<IMavenProjectFacade> getImpactedProjects(IMavenProjectRegistry projectManager) {
        ArrayList<IMavenProjectFacade> facades = new ArrayList<IMavenProjectFacade>();
        IProject project = this.getProject();
        if (project == null) {
            IMavenProjectFacade[] iMavenProjectFacadeArray = projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                if (this.isImpacted(facade.getProject())) {
                    facades.add(facade);
                }
                ++n2;
            }
        } else {
            facades.add(projectManager.getProject(project));
        }
        return facades;
    }

    private boolean isImpacted(IProject project) {
        return !this.preferencesManager.hasSpecificProjectSettings(project);
    }
}

