/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.internal;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.internal.Activator;

public class LaunchConfigProviderInfo {
    private final String descriptorTypeId;
    private final int priority;
    private IConfigurationElement element;
    private ILaunchConfigurationProvider provider;
    private Expression expression;

    public LaunchConfigProviderInfo(IConfigurationElement element) {
        int priorityNum;
        this.descriptorTypeId = element.getAttribute("descriptorType");
        String priorityStr = element.getAttribute("priority");
        try {
            priorityNum = Integer.parseInt(priorityStr);
        }
        catch (NumberFormatException numberFormatException) {
            priorityNum = 0;
        }
        this.priority = priorityNum;
        this.element = element;
        IConfigurationElement[] enabledExpressions = element.getChildren("enablement");
        if (enabledExpressions == null || enabledExpressions.length == 0) {
            Activator.log((IStatus)new Status(2, "org.eclipse.launchbar.core", "Enablement expression is missing for config provider for " + this.descriptorTypeId));
        } else if (enabledExpressions.length > 1) {
            Activator.log((IStatus)new Status(2, "org.eclipse.launchbar.core", "Multiple enablement expressions are detected for config provider for " + this.descriptorTypeId));
        } else {
            try {
                this.expression = ExpressionConverter.getDefault().perform(enabledExpressions[0]);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            if (this.expression == null) {
                Activator.log((IStatus)new Status(4, "org.eclipse.launchbar.core", "Cannot parse enablement expression defined in config provider for " + this.descriptorTypeId));
            }
        }
    }

    public String getDescriptorTypeId() {
        return this.descriptorTypeId;
    }

    public int getPriority() {
        return this.priority;
    }

    public ILaunchConfigurationProvider getProvider() throws CoreException {
        if (this.provider == null) {
            this.provider = (ILaunchConfigurationProvider)this.element.createExecutableExtension("class");
            this.element = null;
        }
        return this.provider;
    }

    public boolean enabled(Object element) throws CoreException {
        if (this.expression == null) {
            return true;
        }
        EvaluationResult result = this.expression.evaluate((IEvaluationContext)new EvaluationContext(null, element));
        return result == EvaluationResult.TRUE;
    }
}

