/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrimaryKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUniqueConstraint;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.impl.ForeignKeyImpl;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogForeignKey
extends ForeignKeyImpl
implements ICatalogObject {
    private boolean memberLoaded = false;
    private boolean uniqueConstraintLoaded = false;
    private boolean dependencyLoaded = false;

    public void refresh() {
        if (this.memberLoaded) {
            this.members.clear();
            this.memberLoaded = false;
        }
        this.uniqueConstraintLoaded = false;
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public EList getMembers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getMembers();
        }
        if (!this.memberLoaded) {
            this.loadMembers();
        }
        return this.members;
    }

    public UniqueConstraint getUniqueConstraint() {
        if (!this.uniqueConstraintLoaded) {
            this.loadUniqueConstraint();
        }
        return this.uniqueConstraint;
    }

    public ReferentialActionType getOnDelete() {
        if (!this.uniqueConstraintLoaded) {
            this.loadUniqueConstraint();
        }
        return this.onDelete;
    }

    public ReferentialActionType getOnUpdate() {
        if (!this.uniqueConstraintLoaded) {
            this.loadUniqueConstraint();
        }
        return this.onUpdate;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 12) {
            this.getMembers();
        } else if (id == 15) {
            this.getOnDelete();
        } else if (id == 14) {
            this.getOnUpdate();
        } else if (id == 16) {
            this.getUniqueConstraint();
        } else if (id == 2) {
            this.getDependencies();
        }
        return super.eIsSet(eFeature);
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    private synchronized void loadMembers() {
        if (this.memberLoaded) {
            return;
        }
        this.memberLoaded = true;
        EList memberList = super.getMembers();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT COLNAME FROM SYSCAT.KEYCOLUSE" + this.getWhereClause() + "  ORDER BY COLSEQ");
            while (r.next()) {
                String colName = r.getString(1);
                memberList.add((Object)this.getColumn(colName));
            }
            r.close();
            s.close();
            LUWCatalogForeignKey.setAsIdentifyingRelatinship((ForeignKey)this, this.isIdentifyingRelationship(memberList));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void setAsIdentifyingRelatinship(ForeignKey fk, boolean identifying) {
        EAnnotation eAnnotation = fk.addEAnnotation(RDBCorePlugin.FK_MODELING_RELATIONSHIP);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_IS_IDENTIFYING_RELATIONSHIP, new Boolean(identifying).toString());
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_CHILD_MULTIPLICITY, RDBCorePlugin.MANY);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_CHILD_ROLE_NAME, new String());
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_PARENT_MULTIPLICITY, fk.getMembers().size() > 0 ? RDBCorePlugin.ZERO_TO_ONE : RDBCorePlugin.ONE);
        fk.addEAnnotationDetail(eAnnotation, RDBCorePlugin.FK_PARENT_ROLE_NAME, new String());
    }

    private synchronized void loadUniqueConstraint() {
        if (this.uniqueConstraintLoaded) {
            return;
        }
        this.uniqueConstraintLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT REFKEYNAME, REFTABSCHEMA, REFTABNAME, DELETERULE, UPDATERULE FROM SYSCAT.REFERENCES" + this.getWhereClause());
            while (r.next()) {
                String refKeyName = r.getString(1);
                String refTabSchema = r.getString(2).trim();
                String refTabName = r.getString(3);
                this.setParentConstraint(refTabSchema, refTabName, refKeyName);
                String onDeleteStr = r.getString(4);
                String onUpdateStr = r.getString(5);
                if (onDeleteStr.equals("A")) {
                    this.onDelete = ReferentialActionType.NO_ACTION_LITERAL;
                } else if (onDeleteStr.equals("C")) {
                    this.onDelete = ReferentialActionType.CASCADE_LITERAL;
                } else if (onDeleteStr.equals("N")) {
                    this.onDelete = ReferentialActionType.SET_NULL_LITERAL;
                } else if (onDeleteStr.equals("R")) {
                    this.onDelete = ReferentialActionType.RESTRICT_LITERAL;
                }
                if (onUpdateStr.equals("A")) {
                    this.onUpdate = ReferentialActionType.NO_ACTION_LITERAL;
                    continue;
                }
                if (!onUpdateStr.equals("R")) continue;
                this.onUpdate = ReferentialActionType.RESTRICT_LITERAL;
            }
            r.close();
            s.close();
            this.loadMembers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogPrimaryKey.loadDependencies(this.getConnection(), super.getDependencies(), (Constraint)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private String getWhereClause() {
        this.getBaseTable();
        return " WHERE CONSTNAME='" + LUWUtil.getIdentifier(this.getName()) + "' AND TABSCHEMA='" + LUWUtil.getIdentifier(this.getBaseTable().getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(this.getBaseTable().getName()) + "'";
    }

    private Column getColumn(String columnName) {
        Column c;
        BaseTable table = this.getBaseTable();
        if (table instanceof LUWCatalogTable && (c = ((LUWCatalogTable)table).getColumn(columnName)) != null) {
            return c;
        }
        for (Column c2 : table.getColumns()) {
            if (!c2.getName().equals(columnName)) continue;
            return c2;
        }
        LUWCatalogColumn column = new LUWCatalogColumn();
        column.setName(columnName);
        column.setTable((Table)table);
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition def = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        CharacterStringDataType dataType = (CharacterStringDataType)def.getPredefinedDataType("Char");
        dataType.setLength(5);
        column.setContainedType((SQLDataType)dataType);
        return column;
    }

    private Schema getSchema(String schemaName) {
        Schema s2 = this.getBaseTable().getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database d = s2.getDatabase();
        if (d instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)d).getSchema(schemaName)) != null) {
            return s2;
        }
        for (Schema s2 : d.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(d);
        if (d instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)d).cacheSchema((Schema)schema);
        }
        return schema;
    }

    private Table getTable(String schemaName, String tableName) {
        LUWCatalogTable table2;
        Table t;
        Schema schema = this.getSchema(schemaName);
        if (schema instanceof LUWCatalogSchema && (t = ((LUWCatalogSchema)schema).getTable(schemaName, tableName)) != null) {
            return t;
        }
        for (LUWCatalogTable table2 : schema.getTables()) {
            if (!table2.getName().equals(tableName)) continue;
            return table2;
        }
        table2 = new LUWCatalogTable();
        table2.setName(tableName);
        table2.setSchema(schema);
        return table2;
    }

    private void setParentConstraint(String schemaName, String tableName, String constraintName) {
        BaseTable table = (BaseTable)this.getTable(schemaName, tableName);
        this.setReferencedTable(table);
        for (Constraint constraint : table.getConstraints()) {
            if (!constraint.getName().equals(constraintName)) continue;
            this.setUniqueConstraint((UniqueConstraint)constraint);
            return;
        }
        for (Index index : table.getIndex()) {
            if (!index.getName().equals(constraintName)) continue;
            this.setUniqueIndex(index);
            return;
        }
        LUWCatalogUniqueConstraint uniqueConstrain = new LUWCatalogUniqueConstraint();
        uniqueConstrain.setName(constraintName);
        uniqueConstrain.setBaseTable(table);
        this.setUniqueConstraint((UniqueConstraint)uniqueConstrain);
    }

    private boolean isIdentifyingRelationship(EList memberList) {
        boolean isIdentifying = true;
        for (Column column : memberList) {
            if (column.isPartOfPrimaryKey()) continue;
            isIdentifying = false;
        }
        return isIdentifying;
    }
}

