/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnectionPageModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NewDockerConnectionPage
extends WizardPage {
    private final DataBindingContext dbc;
    private final NewDockerConnectionPageModel model;

    public NewDockerConnectionPage() {
        super("NewDockerConnectionPage", WizardMessages.getString("NewDockerConnectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("NewDockerConnectionPage.msg"));
        this.model = new NewDockerConnectionPageModel();
        this.dbc = new DataBindingContext();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createConnectionSettingsContainer(container);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.retrieveDefaultConnectionSettings();
        this.setControl((Control)container);
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.dispose();
    }

    private void createConnectionSettingsContainer(Composite parent) {
        int COLUMNS = 3;
        int INDENT = 20;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo(container);
        Label connectionNameLabel = new Label(container, 0);
        connectionNameLabel.setText(WizardMessages.getString("NewDockerConnectionPage.nameLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)connectionNameLabel);
        Text connectionNameText = new Text(container, 2048);
        connectionNameText.setToolTipText(WizardMessages.getString("NewDockerConnectionPage.nameTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)connectionNameText);
        Button customConnectionSettingsButton = new Button(container, 32);
        customConnectionSettingsButton.setText(WizardMessages.getString("NewDockerConnectionPage.customLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(0, 10).span(3, 1).applyTo((Control)customConnectionSettingsButton);
        Group customSettingsGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).grab(true, false).applyTo((Control)customSettingsGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).spacing(10, 2).applyTo((Composite)customSettingsGroup);
        Button unixSocketBindingModeButton = new Button((Composite)customSettingsGroup, 16);
        unixSocketBindingModeButton.setText(WizardMessages.getString("NewDockerConnectionPage.unixSocket"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)unixSocketBindingModeButton);
        Label unixSocketPathLabel = new Label((Composite)customSettingsGroup, 0);
        unixSocketPathLabel.setText(WizardMessages.getString("NewDockerConnectionPage.location"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)unixSocketPathLabel);
        Text unixSocketPathText = new Text((Composite)customSettingsGroup, 2048);
        unixSocketPathText.setToolTipText(WizardMessages.getString("NewDockerConnectionPage.unixPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)unixSocketPathText);
        Button unixSocketPathBrowseButton = new Button((Composite)customSettingsGroup, 524288);
        unixSocketPathBrowseButton.setText(WizardMessages.getString("NewDockerConnectionPage.browseButton"));
        unixSocketPathBrowseButton.addSelectionListener(this.onBrowseUnixSocketPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)unixSocketPathBrowseButton);
        Button tcpConnectionBindingModeButton = new Button((Composite)customSettingsGroup, 16);
        tcpConnectionBindingModeButton.setText(WizardMessages.getString("NewDockerConnectionPage.tcpConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)tcpConnectionBindingModeButton);
        Label tcpHostLabel = new Label((Composite)customSettingsGroup, 0);
        tcpHostLabel.setText(WizardMessages.getString("NewDockerConnectionPage.hostLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).applyTo((Control)tcpHostLabel);
        Text tcpHostText = new Text((Composite)customSettingsGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)tcpHostText);
        Button tcpAuthButton = new Button((Composite)customSettingsGroup, 32);
        tcpAuthButton.setText(WizardMessages.getString("NewDockerConnectionPage.tcpAuthButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(20, 0).span(3, 1).applyTo((Control)tcpAuthButton);
        Label tcpCertPathLabel = new Label((Composite)customSettingsGroup, 0);
        tcpCertPathLabel.setText(WizardMessages.getString("NewDockerConnectionPage.tcpPathLabel"));
        tcpCertPathLabel.setToolTipText(WizardMessages.getString("NewDockerConnectionPage.tcpPathTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).indent(40, 0).applyTo((Control)tcpCertPathLabel);
        Text tcpCertPathText = new Text((Composite)customSettingsGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)tcpCertPathText);
        Button tcpCertPathBrowseButton = new Button((Composite)customSettingsGroup, 524288);
        tcpCertPathBrowseButton.setText(WizardMessages.getString("NewDockerConnectionPage.browseButton"));
        tcpCertPathBrowseButton.addSelectionListener(this.onBrowseTcpCertPath());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)tcpCertPathBrowseButton);
        Button testConnectionButton = new Button(container, 0);
        testConnectionButton.setText(WizardMessages.getString("NewDockerConnectionPage.testConnection"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).align(0x1000008, 0x1000000).applyTo((Control)testConnectionButton);
        testConnectionButton.addSelectionListener(this.onTestConnectionButtonSelection());
        IObservableValue connectionNameModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"connectionName").observe((Object)this.model);
        IObservableValue unixSocketBindingModeModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"unixSocketBindingMode").observe((Object)this.model);
        IObservableValue unixSocketPathModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"unixSocketPath").observe((Object)this.model);
        IObservableValue customConnectionSettingsModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"customSettings").observe((Object)this.model);
        IObservableValue tcpConnectionBindingModeModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpConnectionBindingMode").observe((Object)this.model);
        IObservableValue tcpCertPathModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpCertPath").observe((Object)this.model);
        IObservableValue tcpTlsVerifyModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpTLSVerify").observe((Object)this.model);
        IObservableValue tcpHostModelObservable = BeanProperties.value(NewDockerConnectionPageModel.class, (String)"tcpHost").observe((Object)this.model);
        Control[] bindingModeSelectionControls = new Control[]{unixSocketBindingModeButton, tcpConnectionBindingModeButton};
        Control[] unixSocketControls = new Control[]{unixSocketPathText, unixSocketPathLabel, unixSocketPathBrowseButton};
        Control[] tcpConnectionControls = new Control[]{tcpHostText, tcpHostLabel, tcpAuthButton};
        Control[] tcpAuthControls = new Control[]{tcpCertPathText, tcpCertPathLabel, tcpCertPathBrowseButton};
        customConnectionSettingsModelObservable.addValueChangeListener(this.onCustomConnectionSettingsSelection(bindingModeSelectionControls, unixSocketControls, tcpAuthControls, tcpConnectionControls));
        unixSocketBindingModeModelObservable.addChangeListener(this.onUnixSocketBindingSelection(unixSocketControls));
        tcpConnectionBindingModeModelObservable.addChangeListener(this.onTcpConnectionBindingSelection(tcpConnectionControls, tcpAuthControls));
        tcpTlsVerifyModelObservable.addValueChangeListener(this.onTcpAuthSelection(tcpAuthControls));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)connectionNameText), connectionNameModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)customConnectionSettingsButton), customConnectionSettingsModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)unixSocketBindingModeButton), unixSocketBindingModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)unixSocketPathText), unixSocketPathModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)tcpConnectionBindingModeButton), tcpConnectionBindingModeModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tcpHostText), tcpHostModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)tcpAuthButton), tcpTlsVerifyModelObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tcpCertPathText), tcpCertPathModelObservable);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new ConnectionNameValidator(connectionNameModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new UnixSocketValidator(unixSocketBindingModeModelObservable, unixSocketPathModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new TcpHostValidator(tcpConnectionBindingModeModelObservable, tcpHostModelObservable));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new TcpCertificatesValidator(tcpConnectionBindingModeModelObservable, tcpTlsVerifyModelObservable, tcpCertPathModelObservable));
        connectionNameText.setFocus();
        this.updateWidgetsState(bindingModeSelectionControls, unixSocketControls, tcpConnectionControls, tcpAuthControls);
    }

    private SelectionListener onBrowseUnixSocketPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(NewDockerConnectionPage.this.getShell());
                String selectedPath = fileDialog.open();
                if (selectedPath != null) {
                    NewDockerConnectionPage.this.model.setUnixSocketPath("unix://" + selectedPath);
                }
            }
        };
    }

    private SelectionListener onBrowseTcpCertPath() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(NewDockerConnectionPage.this.getShell());
                String selectedPath = directoryDialog.open();
                if (selectedPath != null) {
                    NewDockerConnectionPage.this.model.setTcpCertPath(selectedPath);
                }
            }
        };
    }

    private void retrieveDefaultConnectionSettings() {
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(WizardMessages.getString("NewDockerConnectionPage.retrieveTask"), 1);
                    DockerConnection.Defaults defaults = new DockerConnection.Defaults();
                    NewDockerConnectionPage.this.model.setTcpCertPath(defaults.getTcpCertPath());
                    NewDockerConnectionPage.this.model.setTcpTLSVerify(defaults.getTcpTlsVerify());
                    NewDockerConnectionPage.this.model.setTcpHost(defaults.getTcpHost());
                    NewDockerConnectionPage.this.model.setUnixSocketPath(defaults.getUnixSocketPath());
                    NewDockerConnectionPage.this.model.setBindingMode(defaults.getBindingMode());
                    NewDockerConnectionPage.this.model.setCustomSettings(!defaults.isSettingsResolved());
                    NewDockerConnectionPage.this.model.setConnectionName(defaults.getName());
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    private void updateWidgetsState(Control[] bindingModeSelectionControls, Control[] unixSocketControls, Control[] tcpConnectionControls, Control[] tcpAuthControls) {
        this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode() && this.model.isTcpTLSVerify(), tcpAuthControls);
        this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isTcpConnectionBindingMode(), tcpConnectionControls);
        this.setWidgetsEnabled(this.model.isCustomSettings() && this.model.isUnixSocketBindingMode(), unixSocketControls);
        this.setWidgetsEnabled(this.model.isCustomSettings(), bindingModeSelectionControls);
    }

    private IValueChangeListener onCustomConnectionSettingsSelection(final Control[] bindingModeSelectionControls, final Control[] unixSocketControls, final Control[] tcpAuthControls, final Control[] tcpConnectionControls) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                NewDockerConnectionPage.this.updateWidgetsState(bindingModeSelectionControls, unixSocketControls, tcpConnectionControls, tcpAuthControls);
            }
        };
    }

    private IChangeListener onUnixSocketBindingSelection(final Control[] unixSocketControls) {
        return new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewDockerConnectionPage.this.setWidgetsEnabled(NewDockerConnectionPage.this.model.isCustomSettings() && NewDockerConnectionPage.this.model.isUnixSocketBindingMode(), unixSocketControls);
            }
        };
    }

    private IChangeListener onTcpConnectionBindingSelection(final Control[] tcpConnectionControls, final Control[] tcpAuthControls) {
        return new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                NewDockerConnectionPage.this.setWidgetsEnabled(NewDockerConnectionPage.this.model.isCustomSettings() && NewDockerConnectionPage.this.model.isTcpConnectionBindingMode() && NewDockerConnectionPage.this.model.isTcpTLSVerify(), tcpAuthControls);
                NewDockerConnectionPage.this.setWidgetsEnabled(NewDockerConnectionPage.this.model.isCustomSettings() && NewDockerConnectionPage.this.model.isTcpConnectionBindingMode(), tcpConnectionControls);
            }
        };
    }

    private IValueChangeListener onTcpAuthSelection(final Control[] tcpAuthControls) {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                NewDockerConnectionPage.this.setWidgetsEnabled(NewDockerConnectionPage.this.model.isCustomSettings() && NewDockerConnectionPage.this.model.isTcpConnectionBindingMode() && NewDockerConnectionPage.this.model.isTcpTLSVerify(), tcpAuthControls);
            }
        };
    }

    private void setWidgetsEnabled(boolean enabled, Control ... controls) {
        Control control;
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
        if (enabled) {
            controlArray = controls;
            n = controls.length;
            n2 = 0;
            while (n2 < n) {
                control = controlArray[n2];
                if (control instanceof Text) {
                    control.setFocus();
                    break;
                }
                ++n2;
            }
        }
    }

    private SelectionListener onTestConnectionButtonSelection() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(1);
                try {
                    NewDockerConnectionPage.this.getWizard().getContainer().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask(WizardMessages.getString("NewDockerConnectionPage.pingTask"), -1);
                            try {
                                DockerConnection dockerConnection = NewDockerConnectionPage.this.getDockerConnection();
                                dockerConnection.open(false);
                                dockerConnection.ping();
                                dockerConnection.close();
                                resultQueue.add(true);
                            }
                            catch (DockerException e) {
                                Activator.log(e);
                                resultQueue.add(false);
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException o_O) {
                    Activator.log(o_O);
                }
                try {
                    Boolean result = (Boolean)resultQueue.poll(5000L, TimeUnit.MILLISECONDS);
                    if (result != null && result.booleanValue()) {
                        new MessageDialog(Display.getDefault().getActiveShell(), WizardMessages.getString("NewDockerConnectionPage.success"), null, WizardMessages.getString("NewDockerConnectionPage.pingSuccess"), 2, new String[]{WizardMessages.getString("NewDockerConnectionPage.ok")}, 0).open();
                    } else {
                        new MessageDialog(Display.getDefault().getActiveShell(), WizardMessages.getString("NewDockerConnectionPage.failure"), null, WizardMessages.getString("NewDockerConnectionPage.pingFailure"), 1, new String[]{WizardMessages.getString("NewDockerConnectionPage.ok")}, 0).open();
                    }
                }
                catch (InterruptedException o_O) {
                    new MessageDialog(Display.getDefault().getActiveShell(), WizardMessages.getString("NewDockerConnectionPage.failure"), null, WizardMessages.getString("NewDockerConnectionPage.pingFailure"), 1, new String[]{WizardMessages.getString("NewDockerConnectionPage.ok")}, 0).open();
                }
            }
        };
    }

    protected DockerConnection getDockerConnection() {
        if (this.model.getBindingMode() == EnumDockerConnectionSettings.UNIX_SOCKET) {
            return new DockerConnection.Builder().name(this.model.getConnectionName()).unixSocket(this.model.getUnixSocketPath()).build();
        }
        DockerConnection.Builder tcpConnectionBuilder = new DockerConnection.Builder().name(this.model.getConnectionName()).tcpHost(this.model.getTcpHost());
        if (this.model.isTcpTLSVerify()) {
            tcpConnectionBuilder.tcpCertPath(this.model.getTcpCertPath());
        }
        return tcpConnectionBuilder.build();
    }

    private static class ConnectionNameValidator
    extends MultiValidator {
        private final IObservableValue connectionNameModelObservable;

        public ConnectionNameValidator(IObservableValue connectionNameModelObservable) {
            this.connectionNameModelObservable = connectionNameModelObservable;
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.connectionNameModelObservable);
            return targets;
        }

        protected IStatus validate() {
            String connectionName = (String)this.connectionNameModelObservable.getValue();
            if (connectionName == null || connectionName.isEmpty()) {
                return ValidationStatus.cancel((String)WizardMessages.getString("NewDockerConnectionPage.validation.missingConnectionName.msg"));
            }
            if (DockerConnectionManager.getInstance().findConnection(connectionName) != null) {
                return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.duplicateConnectionName.msg"));
            }
            return ValidationStatus.ok();
        }
    }

    private static class TcpCertificatesValidator
    extends MultiValidator {
        private final IObservableValue tcpConnectionBindingModeModelObservable;
        private final IObservableValue tcpTlsVerifyModelObservable;
        private final IObservableValue tcpCertPathModelObservable;

        public TcpCertificatesValidator(IObservableValue tcpConnectionBindingModeModelObservable, IObservableValue tcpTlsVerifyModelObservable, IObservableValue tcpCertPathModelObservable) {
            this.tcpConnectionBindingModeModelObservable = tcpConnectionBindingModeModelObservable;
            this.tcpTlsVerifyModelObservable = tcpTlsVerifyModelObservable;
            this.tcpCertPathModelObservable = tcpCertPathModelObservable;
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.tcpCertPathModelObservable);
            return targets;
        }

        protected IStatus validate() {
            Boolean tcpConnectionBindingMode = (Boolean)this.tcpConnectionBindingModeModelObservable.getValue();
            Boolean tcpTlsVerify = (Boolean)this.tcpTlsVerifyModelObservable.getValue();
            String tcpCertPath = (String)this.tcpCertPathModelObservable.getValue();
            if (tcpConnectionBindingMode.booleanValue() && tcpTlsVerify.booleanValue()) {
                if (tcpCertPath == null || tcpCertPath.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.missingTcpCertPath.msg"));
                }
                File tcpCert = new File(tcpCertPath);
                if (!tcpCert.exists()) {
                    return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidTcpCertPath.msg"));
                }
                if (!tcpCert.canRead() || !tcpCert.canRead()) {
                    return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.unreadableTcpCertPath.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }

    private static class TcpHostValidator
    extends MultiValidator {
        private final IObservableValue tcpConnectionBindingModeModelObservable;
        private final IObservableValue tcpHostModelObservable;

        public TcpHostValidator(IObservableValue tcpConnectionBindingModeModelObservable, IObservableValue tcpHostModelObservable) {
            this.tcpConnectionBindingModeModelObservable = tcpConnectionBindingModeModelObservable;
            this.tcpHostModelObservable = tcpHostModelObservable;
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.tcpHostModelObservable);
            return targets;
        }

        protected IStatus validate() {
            Boolean tcpConnectionBindingMode = (Boolean)this.tcpConnectionBindingModeModelObservable.getValue();
            String tcpHost = (String)this.tcpHostModelObservable.getValue();
            if (tcpConnectionBindingMode.booleanValue()) {
                if (tcpHost == null || tcpHost.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.missingTcpConnectionURI.msg"));
                }
                try {
                    URI uri = new URI(tcpHost);
                    String scheme = uri.getScheme() != null ? uri.getScheme().toLowerCase() : null;
                    String host = uri.getHost();
                    int port = uri.getPort();
                    if (!(scheme == null || scheme.equals("tcp") || scheme.equals("http") || scheme.equals("https"))) {
                        return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidTcpConnectionScheme.msg"));
                    }
                    if (host == null) {
                        return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidTcpConnectionHost.msg"));
                    }
                    if (port == -1) {
                        return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidTcpConnectionPort.msg"));
                    }
                }
                catch (URISyntaxException e) {
                    return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidTcpConnectionURI.msg"));
                }
            }
            return ValidationStatus.ok();
        }
    }

    private static class UnixSocketValidator
    extends MultiValidator {
        private final IObservableValue unixSocketBindingModeModelObservable;
        private final IObservableValue unixSocketPathModelObservable;

        public UnixSocketValidator(IObservableValue unixSocketBindingModeModelObservable, IObservableValue unixSocketPathModelObservable) {
            this.unixSocketBindingModeModelObservable = unixSocketBindingModeModelObservable;
            this.unixSocketPathModelObservable = unixSocketPathModelObservable;
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.unixSocketPathModelObservable);
            return targets;
        }

        protected IStatus validate() {
            block8: {
                Boolean unixSocketBindingMode = (Boolean)this.unixSocketBindingModeModelObservable.getValue();
                String unixSocketPath = (String)this.unixSocketPathModelObservable.getValue();
                if (unixSocketBindingMode.booleanValue()) {
                    if (unixSocketPath == null || unixSocketPath.isEmpty()) {
                        return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.missingUnixSocket.msg"));
                    }
                    try {
                        URI unixSocketURI = new URI(unixSocketPath);
                        if (unixSocketURI.getScheme() != null && !unixSocketURI.getScheme().equals("unix")) {
                            return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidUnixSocketScheme.msg"));
                        }
                        if (unixSocketURI.getPath() != null) {
                            File unixSocket = new File(unixSocketURI.getPath());
                            if (!unixSocket.exists()) {
                                return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                            }
                            if (!unixSocket.canRead() || !unixSocket.canWrite()) {
                                return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.unreadableUnixSocket.msg"));
                            }
                            break block8;
                        }
                        return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                    }
                    catch (URISyntaxException e) {
                        return ValidationStatus.error((String)WizardMessages.getString("NewDockerConnectionPage.validation.invalidUnixSocketPath.msg"));
                    }
                }
            }
            return ValidationStatus.ok();
        }
    }
}

