/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;

public class ImageRunSelectionModel
extends BaseDatabindingModel {
    public static final String SELECTED_IMAGE_NAME = "selectedImageName";
    public static final String SELECTED_IMAGE = "selectedImage";
    public static final String SELECTED_IMAGE_NEEDS_PULLING = "selectedImageNeedsPulling";
    public static final String IMAGE_NAMES = "imageNames";
    public static final String CONTAINER_NAME = "containerName";
    public static final String COMMAND = "command";
    public static final String ENTRYPOINT = "entrypoint";
    public static final String PUBLISH_ALL_PORTS = "publishAllPorts";
    public static final String EXPOSED_PORTS = "exposedPorts";
    public static final String SELECTED_PORTS = "selectedPorts";
    public static final String LINKS = "links";
    public static final String INTERACTIVE_MODE = "interactiveMode";
    public static final String ALLOCATE_PSEUDO_TTY = "allocatePseudoTTY";
    public static final String REMOVE_WHEN_EXITS = "removeWhenExits";
    private final IDockerConnection selectedConnection;
    private String selectedImageName;
    private boolean selectedImageNeedsPulling = false;
    private List<String> imageNames;
    private Map<String, IDockerImage> images;
    private String containerName;
    private String command;
    private String entrypoint;
    private boolean publishAllPorts = true;
    private WritableList exposedPorts = new WritableList();
    private Set<ExposedPortModel> selectedPorts = new HashSet<ExposedPortModel>();
    private WritableList links = new WritableList();
    private boolean interactiveMode = false;
    private boolean allocatePseudoTTY = false;
    private boolean removeWhenExits = false;

    public ImageRunSelectionModel(IDockerConnection selectedConnection) {
        this.selectedConnection = selectedConnection;
        this.refreshImageNames();
    }

    public void refreshImageNames() {
        this.imageNames = new ArrayList<String>();
        this.images = new HashMap<String, IDockerImage>();
        for (IDockerImage image : this.selectedConnection.getImages()) {
            if (image.isIntermediateImage() || image.isDangling()) continue;
            for (String tag : image.tags()) {
                String imageName = ImageRunSelectionModel.getImageName(image.repo(), tag);
                this.images.put(imageName, image);
                this.imageNames.add(imageName);
            }
        }
    }

    public ImageRunSelectionModel(IDockerImage selectedImage) {
        this(selectedImage.getConnection());
        if (selectedImage.tags().contains("latest")) {
            this.setSelectedImageName(ImageRunSelectionModel.getImageName(selectedImage.repo(), "latest"));
        } else {
            String lastTag = (String)selectedImage.tags().get(selectedImage.tags().size() - 1);
            this.setSelectedImageName(ImageRunSelectionModel.getImageName(selectedImage.repo(), lastTag));
        }
    }

    public boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        this.firePropertyChange(PUBLISH_ALL_PORTS, this.publishAllPorts, this.publishAllPorts);
    }

    public List<String> getImageNames() {
        return this.imageNames;
    }

    public void setImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        this.firePropertyChange(IMAGE_NAMES, this.imageNames, this.imageNames);
    }

    public IDockerConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public String getSelectedImageName() {
        return this.selectedImageName;
    }

    public boolean isSelectedImageNeedsPulling() {
        return this.selectedImageNeedsPulling;
    }

    public void setSelectedImageNeedsPulling(boolean selectedImageNeedsPulling) {
        this.selectedImageNeedsPulling = selectedImageNeedsPulling;
        this.firePropertyChange(SELECTED_IMAGE_NEEDS_PULLING, this.selectedImageNeedsPulling, this.selectedImageNeedsPulling);
    }

    public void setSelectedImageName(String selectedImageName) {
        this.selectedImageName = selectedImageName;
        this.firePropertyChange(SELECTED_IMAGE_NAME, this.selectedImageName, this.selectedImageName);
    }

    public IDockerImage getSelectedImage() {
        return this.images.get(this.selectedImageName);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
        this.firePropertyChange(CONTAINER_NAME, this.containerName, this.containerName);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
        this.firePropertyChange(COMMAND, this.command, this.command);
    }

    public void setCommand(List<String> cmdElements) {
        StringBuilder commandBuilder = new StringBuilder();
        if (cmdElements != null) {
            for (String cmdElement : cmdElements) {
                commandBuilder.append(cmdElement).append(' ');
            }
        }
        this.setCommand(commandBuilder.toString());
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
        this.firePropertyChange(ENTRYPOINT, this.entrypoint, this.entrypoint);
    }

    public void setEntrypoint(List<String> entrypointElements) {
        StringBuilder entrypointBuilder = new StringBuilder();
        if (entrypointElements != null) {
            for (String entrypoint : entrypointElements) {
                entrypointBuilder.append(entrypoint).append(' ');
            }
        }
        this.setEntrypoint(entrypointBuilder.toString());
    }

    public WritableList getExposedPorts() {
        return this.exposedPorts;
    }

    public void addAvailablePort(ExposedPortModel port) {
        this.exposedPorts.add((Object)port);
    }

    public void removeAvailablePort(ExposedPortModel port) {
        this.exposedPorts.remove((Object)port);
    }

    public void setExposedPorts(WritableList ports) {
        this.exposedPorts.clear();
        this.exposedPorts.addAll((Collection)ports);
    }

    public Set<ExposedPortModel> getSelectedPorts() {
        return this.selectedPorts;
    }

    public void setSelectedPorts(Set<ExposedPortModel> ports) {
        this.selectedPorts = ports;
        this.firePropertyChange(SELECTED_PORTS, this.selectedPorts, this.selectedPorts);
    }

    public WritableList getLinks() {
        return this.links;
    }

    public void addLink(String containerName, String containerAlias) {
        this.links.add((Object)new ContainerLinkModel(containerName, containerAlias));
    }

    public void addLink(int index, String containerName, String containerAlias) {
        this.links.add(index, (Object)new ContainerLinkModel(containerName, containerAlias));
    }

    public void removeLink(ContainerLinkModel link) {
        this.links.remove((Object)link);
    }

    public void setLinks(WritableList links) {
        this.links = links;
        this.firePropertyChange(LINKS, this.links, this.links);
    }

    public static String getImageName(String repo, String tag) {
        return String.valueOf(repo) + ":" + tag;
    }

    public boolean isAllocatePseudoTTY() {
        return this.allocatePseudoTTY;
    }

    public void setAllocatePseudoTTY(boolean allocatePseudoTTY) {
        this.allocatePseudoTTY = allocatePseudoTTY;
        this.firePropertyChange(ALLOCATE_PSEUDO_TTY, this.allocatePseudoTTY, this.allocatePseudoTTY);
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
        this.firePropertyChange(INTERACTIVE_MODE, this.interactiveMode, this.interactiveMode);
    }

    public boolean isRemoveWhenExits() {
        return this.removeWhenExits;
    }

    public void setRemoveWhenExits(boolean removeWhenExits) {
        this.removeWhenExits = removeWhenExits;
        this.firePropertyChange(REMOVE_WHEN_EXITS, this.removeWhenExits, this.removeWhenExits);
    }

    public class ContainerLinkModel
    extends BaseDatabindingModel {
        public static final String CONTAINER_NAME = "containerName";
        public static final String CONTAINER_ALIAS = "containerAlias";
        private String containerName;
        private String containerAlias;

        public ContainerLinkModel() {
        }

        public ContainerLinkModel(String containerName, String alias) {
            this.containerName = containerName;
            this.containerAlias = alias;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
            this.firePropertyChange("containerName", this.containerName, this.containerName);
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String alias) {
            this.containerAlias = alias;
            this.firePropertyChange(CONTAINER_ALIAS, this.containerAlias, this.containerAlias);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.containerAlias == null ? 0 : this.containerAlias.hashCode());
            result = 31 * result + (this.containerName == null ? 0 : this.containerName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerLinkModel other = (ContainerLinkModel)obj;
            if (this.containerAlias == null ? other.containerAlias != null : !this.containerAlias.equals(other.containerAlias)) {
                return false;
            }
            return !(this.containerName == null ? other.containerName != null : !this.containerName.equals(other.containerName));
        }
    }

    public static class ExposedPortModel
    extends BaseDatabindingModel
    implements Comparable<ExposedPortModel> {
        public static final String SELECTED = "selected";
        public static final String CONTAINER_PORT = "containerPort";
        public static final String PORT_TYPE = "portType";
        public static final String HOST_ADDRESS = "hostAddress";
        public static final String HOST_PORT = "hostPort";
        private final String id = UUID.randomUUID().toString();
        private boolean selected;
        private String containerPort;
        private String portType;
        private String hostAddress;
        private String hostPort;

        public ExposedPortModel(String privatePort, String type, String hostAddress, String hostPort) {
            Assert.isNotNull((Object)privatePort, (String)"Port Mapping privatePort cannot be null");
            Assert.isNotNull((Object)type, (String)"Port Mapping portType cannot be null");
            this.containerPort = privatePort;
            this.hostPort = hostPort;
            this.portType = type;
            this.hostAddress = hostAddress;
        }

        public String getContainerPort() {
            return this.containerPort;
        }

        public void setContainerPort(String containerPort) {
            this.containerPort = containerPort;
            this.firePropertyChange(SELECTED, this.containerPort, this.containerPort);
        }

        public String getPortType() {
            return this.portType;
        }

        public void setPortType(String type) {
            this.portType = type;
            this.firePropertyChange(SELECTED, this.portType, this.portType);
        }

        public boolean getSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.firePropertyChange(SELECTED, this.selected, this.selected);
        }

        public String getHostPort() {
            return this.hostPort;
        }

        public void setHostPort(String hostPort) {
            this.hostPort = hostPort;
            this.firePropertyChange(HOST_PORT, this.hostPort, this.hostPort);
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            this.firePropertyChange(HOST_ADDRESS, this.hostAddress, this.hostAddress);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExposedPortModel other = (ExposedPortModel)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        @Override
        public int compareTo(ExposedPortModel other) {
            return this.containerPort.compareTo(other.containerPort);
        }
    }
}

