/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.views.BasePropertySection;
import org.eclipse.linuxtools.internal.docker.ui.views.ContainerInspectContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ContainerInspectPropertySection
extends BasePropertySection {
    private static final String PropertiesInfoError = "PropertiesInfoError.msg";
    private static final String PropertiesLoadingContainerInfo = "PropertiesLoadingContainerInfo.msg";
    private IDockerContainer selectedContainer;
    private Object containerInfo;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.getTreeViewer().setContentProvider((IContentProvider)new ContainerInspectContentProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object input = null;
        if (selection instanceof ITreeSelection) {
            input = ((ITreeSelection)selection).getFirstElement();
        } else if (selection instanceof IStructuredSelection) {
            input = ((IStructuredSelection)selection).getFirstElement();
        }
        Assert.isTrue((boolean)(input instanceof IDockerContainer));
        this.selectedContainer = (IDockerContainer)input;
        IDockerConnection parentConnection = part instanceof DockerContainersView ? ((DockerContainersView)part).getConnection() : (IDockerConnection)((ITreeSelection)selection).getPathsFor((Object)this.selectedContainer)[0].getFirstSegment();
        this.containerInfo = this.getContainerInfo(parentConnection, this.selectedContainer);
        if (this.getTreeViewer() != null && this.containerInfo != null) {
            this.getTreeViewer().setInput(this.containerInfo);
            this.getTreeViewer().expandAll();
        }
    }

    private IDockerContainerInfo getContainerInfo(final IDockerConnection connection, final IDockerContainer container) {
        final ArrayBlockingQueue result = new ArrayBlockingQueue(1);
        Job loadConnectionInfoJob = new Job(DVMessages.getString(PropertiesLoadingContainerInfo)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(ContainerInspectPropertySection.PropertiesLoadingContainerInfo), 1);
                result.add(connection.getContainerInfo(container.id()));
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        loadConnectionInfoJob.schedule();
        try {
            return (IDockerContainerInfo)result.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", DVMessages.getFormattedString(PropertiesInfoError, connection.getName()), (Throwable)e));
            return null;
        }
    }
}

