/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class BasePropertySection
extends AbstractPropertySection {
    private TreeViewer treeViewer;

    public void createControls(Composite parent, TabbedPropertySheetPage propertySheetPage) {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        Composite container = new Composite(parent, 0);
        container.setBackground(Display.getDefault().getSystemColor(25));
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 180).applyTo((Control)container);
        this.treeViewer = this.createTableTreeViewer(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.treeViewer.getControl());
    }

    private TreeViewer createTableTreeViewer(Composite container) {
        TreeViewer treeViewer = new TreeViewer(container, 768);
        Tree tree = treeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        TreeViewerColumn propertyColumn = new TreeViewerColumn(treeViewer, 2048);
        propertyColumn.getColumn().setWidth(150);
        propertyColumn.getColumn().setText("Property");
        propertyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Object[]) {
                    Object property = ((Object[])element)[0];
                    return property.toString();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn valueColumn = new TreeViewerColumn(treeViewer, 2048);
        valueColumn.getColumn().setWidth(500);
        valueColumn.getColumn().setText("Value");
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Object[]) {
                    Object value = ((Object[])element)[1];
                    if (value instanceof Collection) {
                        return "";
                    }
                    if (value instanceof String || value instanceof Boolean || value instanceof Integer) {
                        return value.toString();
                    }
                    return "";
                }
                return super.getText(element);
            }
        });
        return treeViewer;
    }

    TreeViewer getTreeViewer() {
        return this.treeViewer;
    }
}

