/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class BuildDockerImageLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private final String TAB_NAME = "BuildDockerImageLaunchConfigurationMainTab.name";
    private final String SOURCE_PATH_LOCATION_LABEL = "BuildDockerImageLaunchConfigurationMainTab.sourcePathLocation.group.label";
    private final String CONNECTION_LABEL = "BuildDockerImageLaunchConfigurationMainTab.connection.group.label";
    private final String BROWSE_WORKSPACE = "BuildDockerImageLaunchConfigurationMainTab.browseworkspace.button.label";
    private final String BROWSE_WORKSPACE_DIALOG_TITLE = "BuildDockerImageLaunchConfigurationMainTab.browseworkspace.dialog.title";
    private final String BROWSE_WORKSPACE_DIALOG_MESSAGE = "BuildDockerImageLaunchConfigurationMainTab.browseworkspace.dialog.message";
    private final String BROWSE_FILESYSTEM = "BuildDockerImageLaunchConfigurationMainTab.browsefilesystem.button.label";
    private Text sourcePathLocationText;
    private boolean sourcePathWorkspaceRelativeLocation;
    private ComboViewer connectionSelectionComboViewer;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        this.setControl((Control)container);
        Group sourcePathLocationGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)sourcePathLocationGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(3).applyTo((Composite)sourcePathLocationGroup);
        sourcePathLocationGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.sourcePathLocation.group.label"));
        this.sourcePathLocationText = new Text((Composite)sourcePathLocationGroup, 2048);
        this.sourcePathLocationText.addModifyListener((ModifyListener)new LaunchConfigurationChangeListener());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)this.sourcePathLocationText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)new Label((Composite)sourcePathLocationGroup, 0));
        Button browseWorkspaceButton = new Button((Composite)sourcePathLocationGroup, 0);
        browseWorkspaceButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.browseworkspace.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)browseWorkspaceButton);
        browseWorkspaceButton.addSelectionListener(this.onBrowseWorkspace());
        Button browseFileSystemButton = new Button((Composite)sourcePathLocationGroup, 0);
        browseFileSystemButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.browsefilesystem.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)browseFileSystemButton);
        browseFileSystemButton.addSelectionListener(this.onBrowseFileSystem());
        Group connectionGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)connectionGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)connectionGroup);
        connectionGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.connection.group.label"));
        Combo connectionSelectionCombo = new Combo((Composite)connectionGroup, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)connectionSelectionCombo);
        this.connectionSelectionComboViewer = new ComboViewer(connectionSelectionCombo);
        this.connectionSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectionSelectionComboViewer.setInput(this.getConnectionNames());
        connectionSelectionCombo.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
    }

    private List<String> getConnectionNames() {
        ArrayList<String> connectionNames = new ArrayList<String>();
        IDockerConnection[] iDockerConnectionArray = DockerConnectionManager.getInstance().getConnections();
        int n = iDockerConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            connectionNames.add(connection.getName());
            ++n2;
        }
        return connectionNames;
    }

    private SelectionListener onBrowseWorkspace() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(BuildDockerImageLaunchConfigurationMainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setTitle(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.browseworkspace.dialog.title"));
                dialog.setMessage(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.browseworkspace.dialog.message"));
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setAllowMultiple(false);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 1 && selection[0] instanceof IContainer) {
                            return new Status(0, "org.eclipse.linuxtools.docker.ui", null);
                        }
                        return new Status(4, "org.eclipse.linuxtools.docker.ui", null);
                    }
                });
                if (dialog.open() == 0) {
                    IResource selection = (IResource)dialog.getFirstResult();
                    BuildDockerImageLaunchConfigurationMainTab.this.sourcePathLocationText.setText(selection.getFullPath().toOSString());
                    BuildDockerImageLaunchConfigurationMainTab.this.sourcePathWorkspaceRelativeLocation = true;
                }
            }
        };
    }

    private SelectionListener onBrowseFileSystem() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(BuildDockerImageLaunchConfigurationMainTab.this.getShell());
                String selection = dialog.open();
                if (selection != null) {
                    BuildDockerImageLaunchConfigurationMainTab.this.sourcePathLocationText.setText(selection);
                    BuildDockerImageLaunchConfigurationMainTab.this.sourcePathWorkspaceRelativeLocation = false;
                }
            }
        };
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.sourcePathLocationText.setText(configuration.getAttribute("sourcePathLocation", ""));
            this.sourcePathWorkspaceRelativeLocation = configuration.getAttribute("sourcePathWorkspaceRelativeLocation", false);
            this.connectionSelectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)configuration.getAttribute("dockerConnection", "")));
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            if (launchConfig.getAttribute("sourcePathLocation", "").isEmpty()) {
                return false;
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return super.isValid(launchConfig);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("sourcePathLocation", this.sourcePathLocationText.getText());
        configuration.setAttribute("sourcePathWorkspaceRelativeLocation", this.sourcePathWorkspaceRelativeLocation);
        IStructuredSelection connectionSelection = (IStructuredSelection)this.connectionSelectionComboViewer.getSelection();
        if (connectionSelection.getFirstElement() != null) {
            configuration.setAttribute("dockerConnection", connectionSelection.getFirstElement().toString());
        }
    }

    public String getName() {
        return LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.name");
    }

    protected class LaunchConfigurationChangeListener
    extends SelectionAdapter
    implements ModifyListener {
        protected LaunchConfigurationChangeListener() {
        }

        public void modifyText(ModifyEvent e) {
            BuildDockerImageLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            BuildDockerImageLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

