/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class CommandUtils {
    public static void asyncRefresh(final Viewer viewer) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (viewer != null && !viewer.getControl().isDisposed()) {
                    viewer.refresh();
                }
            }
        });
    }

    public static IDockerConnection getCurrentConnection(IWorkbenchPart activePart) {
        if (activePart instanceof DockerContainersView) {
            return ((DockerContainersView)activePart).getConnection();
        }
        if (activePart instanceof DockerImagesView) {
            return ((DockerImagesView)activePart).getConnection();
        }
        if (activePart instanceof DockerExplorerView) {
            ITreeSelection selection = ((DockerExplorerView)activePart).getCommonViewer().getStructuredSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IDockerConnection) {
                return (IDockerConnection)firstElement;
            }
            if (firstElement instanceof IDockerContainer) {
                return ((IDockerContainer)firstElement).getConnection();
            }
            if (firstElement instanceof IDockerImage) {
                return ((IDockerImage)firstElement).getConnection();
            }
            if (firstElement instanceof DockerExplorerContentProvider.DockerImagesCategory) {
                return ((DockerExplorerContentProvider.DockerImagesCategory)firstElement).getConnection();
            }
        }
        return null;
    }

    public static List<IDockerContainer> getSelectedContainers(IWorkbenchPart activePart) {
        if (activePart instanceof DockerContainersView) {
            ISelection selection = ((DockerContainersView)activePart).getSelection();
            return CommandUtils.getSelectedContainers(selection);
        }
        if (activePart instanceof DockerExplorerView) {
            ISelection selection = ((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return CommandUtils.getSelectedContainers(selection);
        }
        return Collections.emptyList();
    }

    public static List<IDockerContainer> getSelectedContainers(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<IDockerContainer> selectedContainers = new ArrayList<IDockerContainer>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof IDockerContainer)) continue;
                selectedContainers.add((IDockerContainer)selectedElement);
            }
            return Collections.unmodifiableList(selectedContainers);
        }
        return Collections.emptyList();
    }

    public static List<IDockerImage> getSelectedImages(IWorkbenchPart activePart) {
        if (activePart instanceof DockerImagesView) {
            ISelection selection = ((DockerImagesView)activePart).getSelection();
            return CommandUtils.getSelectedImages(selection);
        }
        if (activePart instanceof DockerExplorerView) {
            ISelection selection = ((DockerExplorerView)activePart).getCommonViewer().getSelection();
            return CommandUtils.getSelectedImages(selection);
        }
        return Collections.emptyList();
    }

    public static List<IDockerImage> getSelectedImages(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<IDockerImage> selectedImages = new ArrayList<IDockerImage>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof IDockerImage)) continue;
                selectedImages.add((IDockerImage)selectedElement);
            }
            return Collections.unmodifiableList(selectedImages);
        }
        return Collections.emptyList();
    }

    public static RunConsole getRunConsole(IDockerConnection connection, IDockerContainer container) {
        RunConsole console;
        boolean autoLogOnStart = Activator.getDefault().getPreferenceStore().getBoolean("autoLogOnStart");
        if (autoLogOnStart && (console = RunConsole.findConsole(container)) != null) {
            console.attachToConsole(connection);
            console.clearConsole();
            return console;
        }
        return null;
    }

    public static boolean openWizard(IWizard wizard, Shell shell) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }

    public static boolean openWizard(IWizard wizard, Shell shell, int width, int height) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.setPageSize(width, height);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }
}

