/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProgressJob
extends Job {
    private int percentageDone = 0;
    private int percentageChange = 0;
    private Object lockObject = new Object();
    private String jobName;

    public ProgressJob(String name, String jobName) {
        super(name);
        this.jobName = jobName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.jobName, 100);
        boolean done = false;
        while (!done) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            int change = this.getPercentageChange();
            if (change > 0) {
                monitor.worked(change);
                this.setPercentageChange(0);
            }
            if (this.percentageDone >= 100) {
                done = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                done = true;
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPercentageChange() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.percentageChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPercentageChange(int percentChange) {
        Object object = this.lockObject;
        synchronized (object) {
            this.percentageChange = percentChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPercentageDone(int percentage) {
        Object object = this.lockObject;
        synchronized (object) {
            if (percentage > this.percentageDone) {
                this.percentageChange = percentage - this.percentageDone;
                this.percentageDone = percentage;
            }
        }
    }
}

