/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlMutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmMutable
extends AbstractOrmXmlContextModel<OrmAttributeMapping>
implements EclipseLinkMutable {
    protected Boolean specifiedMutable = this.buildSpecifiedMutable();
    protected boolean defaultMutable;

    public EclipseLinkOrmMutable(OrmAttributeMapping parent) {
        super((JpaContextModel)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedMutable_(this.buildSpecifiedMutable());
    }

    public void update() {
        super.update();
        this.setDefaultMutable(this.buildDefaultMutable());
    }

    @Override
    public boolean isMutable() {
        return this.specifiedMutable != null ? this.specifiedMutable : this.defaultMutable;
    }

    @Override
    public Boolean getSpecifiedMutable() {
        return this.specifiedMutable;
    }

    @Override
    public void setSpecifiedMutable(Boolean mutable) {
        this.setSpecifiedMutable_(mutable);
        this.getXmlMutable().setMutable(mutable);
    }

    protected void setSpecifiedMutable_(Boolean mutable) {
        Boolean old = this.specifiedMutable;
        this.specifiedMutable = mutable;
        this.firePropertyChanged("specifiedMutable", old, mutable);
    }

    protected Boolean buildSpecifiedMutable() {
        return this.getXmlMutable().getMutable();
    }

    @Override
    public boolean isDefaultMutable() {
        return this.defaultMutable;
    }

    protected void setDefaultMutable(boolean mutable) {
        boolean old = this.defaultMutable;
        this.defaultMutable = mutable;
        this.firePropertyChanged("defaultMutable", old, mutable);
    }

    protected boolean buildDefaultMutable() {
        EclipseLinkJavaPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        if (javaAttribute == null) {
            return false;
        }
        if (javaAttribute.typeIsDateOrCalendar()) {
            Boolean puTemporalMutable = this.getPersistenceUnit().getEclipseLinkOptions().getTemporalMutable();
            return puTemporalMutable == null ? false : puTemporalMutable;
        }
        return javaAttribute.typeIsSerializable();
    }

    protected OrmAttributeMapping getAttributeMapping() {
        return (OrmAttributeMapping)this.parent;
    }

    protected XmlMutable getXmlMutable() {
        return (XmlMutable)this.getAttributeMapping().getXmlAttributeMapping();
    }

    protected EclipseLinkJavaPersistentAttribute getJavaPersistentAttribute() {
        return (EclipseLinkJavaPersistentAttribute)this.getAttributeMapping().getPersistentAttribute().getJavaPersistentAttribute();
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        return this.getXmlMutable().getMutableTextRange();
    }
}

