/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.RealCallers;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

class ExpandWithConstructorsAction
extends Action {
    private CallHierarchyViewPart fPart;
    private CallHierarchyViewer fCallHierarchyViewer;

    public ExpandWithConstructorsAction(CallHierarchyViewPart callHierarchyViewPart, CallHierarchyViewer callHierarchyViewer) {
        super(CallHierarchyMessages.ExpandWithConstructorsAction_expandWithConstructors_text, 2);
        this.fPart = callHierarchyViewPart;
        this.fCallHierarchyViewer = callHierarchyViewer;
        this.setDescription(CallHierarchyMessages.ExpandWithConstructorsAction_expandWithConstructors_description);
        this.setToolTipText(CallHierarchyMessages.ExpandWithConstructorsAction_expandWithConstructors_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_expand_with_constructors_action_context");
    }

    public void run() {
        boolean isChecked = this.isChecked();
        this.fCallHierarchyViewer.cancelJobs();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        for (CallerMethodWrapper member : selection) {
            member.setExpandWithConstructors(isChecked);
            if (!isChecked) {
                this.fCallHierarchyViewer.setExpandedState((Object)member, false);
            }
            this.fCallHierarchyViewer.refresh((Object)member);
            if (!isChecked) continue;
            this.fCallHierarchyViewer.setExpandedState((Object)member, true);
            this.fCallHierarchyViewer.expandConstructorNode();
        }
    }

    private ISelection getSelection() {
        return this.fPart.getSelection();
    }

    public boolean canActionBeAdded() {
        if (this.fPart.getCallMode() == 1) {
            return false;
        }
        ISelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        boolean allElementsChecked = true;
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        CallerMethodWrapper[] wrappers = new CallerMethodWrapper[structuredSelection.size()];
        int i = 0;
        for (Object element : structuredSelection) {
            if (!(element instanceof CallerMethodWrapper) || element instanceof RealCallers) {
                return false;
            }
            wrappers[i] = (CallerMethodWrapper)((Object)element);
            if (!CallHierarchyContentProvider.canExpandWithConstructors(wrappers[i])) {
                return false;
            }
            int j = 0;
            while (j < i) {
                CallerMethodWrapper parent = (CallerMethodWrapper)wrappers[j].getParent();
                while (parent != null) {
                    if (wrappers[i] == parent) {
                        return false;
                    }
                    parent = (CallerMethodWrapper)parent.getParent();
                }
                CallerMethodWrapper parentElement = (CallerMethodWrapper)wrappers[i].getParent();
                while (parentElement != null) {
                    if (parentElement == wrappers[j]) {
                        return false;
                    }
                    parentElement = (CallerMethodWrapper)parentElement.getParent();
                }
                ++j;
            }
            CallHierarchyContentProvider.ensureDefaultExpandWithConstructors(wrappers[i]);
            if (!wrappers[i].getExpandWithConstructors()) {
                allElementsChecked = false;
            }
            ++i;
        }
        if (allElementsChecked) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
        return true;
    }
}

