/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;

public class StopActiveCommandHandler
extends AbstractHandler {
    private LaunchBarManager launchBarManager = Activator.getDefault().getLaunchBarUIManager().getManager();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.stop();
        return null;
    }

    public void stop() {
        this.stopBuild();
        this.stopActiveLaunches();
    }

    protected void stopActiveLaunches() {
        final ILaunch[] activeLaunches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (activeLaunches != null && activeLaunches.length > 0) {
            new Job(Messages.StopActiveCommandHandler_0){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ILaunchConfiguration activeConfig = StopActiveCommandHandler.this.launchBarManager.getActiveLaunchConfiguration();
                        if (activeConfig == null) {
                            return Status.OK_STATUS;
                        }
                        ILaunch[] iLaunchArray = activeLaunches;
                        int n = activeLaunches.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunch launch = iLaunchArray[n2];
                            ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
                            if (activeConfig.equals(launchConfig)) {
                                launch.terminate();
                            } else if (launchConfig instanceof ILaunchConfigurationWorkingCopy && activeConfig.equals(((ILaunchConfigurationWorkingCopy)launchConfig).getOriginal())) {
                                launch.terminate();
                            }
                            ++n2;
                        }
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    protected void stopBuild() {
        Job job = new Job(Messages.StopActiveCommandHandler_1){

            protected IStatus run(IProgressMonitor progress) {
                Job job;
                IJobManager jobManager = Job.getJobManager();
                Job[] jobs = jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < jobs.length) {
                    job = jobs[i];
                    job.cancel();
                    ++i;
                }
                jobs = jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD);
                i = 0;
                while (i < jobs.length) {
                    job = jobs[i];
                    job.cancel();
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

