/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.ui.internal.LaunchBarUIManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.launchbar.ui";
    public static final String IMG_BUTTON_BUILD = "build";
    public static final String IMG_BUTTON_LAUNCH = "launch";
    public static final String IMG_BUTTON_STOP = "stop";
    public static final String CMD_BUILD = "org.eclipse.launchbar.ui.command.buildActive";
    public static final String CMD_LAUNCH = "org.eclipse.launchbar.ui.command.launchActive";
    public static final String CMD_STOP = "org.eclipse.launchbar.ui.command.stop";
    public static final String CMD_CONFIG = "org.eclipse.launchbar.ui.command.configureActiveLaunch";
    public static final String PREF_ENABLE_LAUNCHBAR = "enableLaunchBar";
    public static final String PREF_LAUNCH_HISTORY_SIZE = "launchHistorySize";
    private static Activator plugin;
    private LaunchBarUIManager launchBarUIManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ImageRegistry imageRegistry = this.getImageRegistry();
        imageRegistry.put(IMG_BUTTON_BUILD, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/build.png"));
        imageRegistry.put(IMG_BUTTON_LAUNCH, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/launch.png"));
        imageRegistry.put(IMG_BUTTON_STOP, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/stop.png"));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public LaunchBarUIManager getLaunchBarUIManager() {
        if (this.launchBarUIManager == null) {
            LaunchBarManager manager = (LaunchBarManager)Activator.getService(ILaunchBarManager.class);
            this.launchBarUIManager = new LaunchBarUIManager(manager);
        }
        return this.launchBarUIManager;
    }

    public Image getImage(String id) {
        ImageDescriptor des;
        Image im = this.getImageRegistry().get(id);
        if (im == null && (des = Activator.getImageDescriptor(id)) != null) {
            im = des.createImage();
            this.getImageRegistry().put(id, im);
        }
        return im;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void runCommand(String commandId, String ... params) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(commandId);
        Event trigger = new Event();
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, trigger);
        if (params.length == 0) {
            try {
                command.executeWithChecks(executionEvent);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (Exception e) {
                Activator.log(e);
            }
        } else {
            try {
                Parameterization[] parameterizations = new Parameterization[params.length / 2];
                int i = 0;
                while (i < params.length) {
                    Parameterization parm;
                    IParameter param = command.getParameter(params[i]);
                    parameterizations[i / 2] = parm = new Parameterization(param, params[i + 1]);
                    i += 2;
                }
                ParameterizedCommand parmCommand = new ParameterizedCommand(command, parameterizations);
                handlerService.executeCommand(parmCommand, null);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void log(Exception e) {
        if (e instanceof CoreException) {
            Activator.log(((CoreException)((Object)e)).getStatus());
        }
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e));
    }

    public static <T> T getService(Class<T> cls) {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(cls);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

