/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import org.eclipse.pde.internal.ui.util.OSGiConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class OSGiConsoleFactory
implements IConsoleFactory {
    private final IConsoleManager fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
    private IOConsole fConsole = null;

    public void openConsole() {
        IOConsole console = this.getConsole();
        IConsole[] existing = this.fConsoleManager.getConsoles();
        boolean exists = false;
        int i = 0;
        while (i < existing.length) {
            if (console == existing[i]) {
                exists = true;
            }
            ++i;
        }
        if (!exists) {
            this.fConsoleManager.addConsoles(new IConsole[]{console});
        }
        this.fConsoleManager.showConsoleView((IConsole)console);
    }

    private synchronized IOConsole getConsole() {
        if (this.fConsole != null) {
            return this.fConsole;
        }
        this.fConsole = new OSGiConsole(this);
        return this.fConsole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConsole(OSGiConsole console) {
        OSGiConsoleFactory oSGiConsoleFactory = this;
        synchronized (oSGiConsoleFactory) {
            if (console != this.fConsole) {
                throw new IllegalArgumentException("Wrong console instance!");
            }
            this.fConsole = null;
        }
        this.fConsoleManager.removeConsoles(new IConsole[]{console});
    }
}

