/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.scm.ScmUrl;
import org.eclipse.m2e.scm.spi.ScmHandler;
import org.eclipse.m2e.scm.spi.ScmHandlerUi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(ScmHandlerFactory.class);
    public static final String EXTENSION_SCM_HANDLERS = "org.eclipse.m2e.scm.scmHandlers";
    public static final String EXTENSION_SCM_HANDLERS_UI = "org.eclipse.m2e.scm.scmHandlersUi";
    private static final String ELEMENT_SCM_HANDLER = "handler";
    private static final String ELEMENT_SCM_HANDLER_UI = "handlerUi";
    private static volatile Map<String, List<ScmHandler>> scms;
    private static volatile Map<String, ScmHandlerUi> scmUis;

    public static synchronized void addScmHandlerUi(ScmHandlerUi handlerUi) {
        ScmHandlerFactory.getScmUis().put(handlerUi.getType(), handlerUi);
    }

    public static synchronized ScmHandlerUi getHandlerUiByType(String type) {
        return type == null ? null : ScmHandlerFactory.getScmUis().get(type);
    }

    public static synchronized void addScmHandler(ScmHandler handler) {
        List<ScmHandler> handlers = ScmHandlerFactory.getScms().get(handler.getType());
        if (handlers == null) {
            handlers = new ArrayList<ScmHandler>();
            ScmHandlerFactory.getScms().put(handler.getType(), handlers);
        }
        handlers.add(handler);
        Collections.sort(handlers);
    }

    public static synchronized String[] getTypes() {
        Map<String, List<ScmHandler>> scms = ScmHandlerFactory.getScms();
        return scms.keySet().toArray(new String[scms.size()]);
    }

    public static synchronized ScmHandler getHandler(String url) throws CoreException {
        String type = ScmUrl.getType(url);
        return ScmHandlerFactory.getHandlerByType(type);
    }

    public static synchronized ScmHandler getHandlerByType(String type) {
        List<ScmHandler> handlers = ScmHandlerFactory.getScms().get(type);
        if (handlers == null) {
            return null;
        }
        return handlers.get(0);
    }

    private static Map<String, List<ScmHandler>> getScms() {
        if (scms == null) {
            scms = new TreeMap<String, List<ScmHandler>>();
            for (ScmHandler scmHandler : ScmHandlerFactory.readScmHanderExtensions()) {
                ScmHandlerFactory.addScmHandler(scmHandler);
            }
        }
        return scms;
    }

    private static Map<String, ScmHandlerUi> getScmUis() {
        if (scmUis == null) {
            scmUis = new TreeMap<String, ScmHandlerUi>();
            List<ScmHandlerUi> scmHandlerUis = ScmHandlerFactory.readScmHandlerUiExtensions();
            for (ScmHandlerUi scmHandlerUi : scmHandlerUis) {
                ScmHandlerFactory.addScmHandlerUi(scmHandlerUi);
            }
        }
        return scmUis;
    }

    private static List<ScmHandler> readScmHanderExtensions() {
        ArrayList<ScmHandler> scmHandlers = new ArrayList<ScmHandler>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint scmHandlersExtensionPoint = registry.getExtensionPoint(EXTENSION_SCM_HANDLERS);
        if (scmHandlersExtensionPoint != null) {
            IExtension[] scmHandlersExtensions;
            IExtension[] iExtensionArray = scmHandlersExtensions = scmHandlersExtensionPoint.getExtensions();
            int n = scmHandlersExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_SCM_HANDLER)) {
                        try {
                            scmHandlers.add((ScmHandler)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return scmHandlers;
    }

    private static List<ScmHandlerUi> readScmHandlerUiExtensions() {
        ArrayList<ScmHandlerUi> scmHandlerUis = new ArrayList<ScmHandlerUi>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint scmHandlersUiExtensionPoint = registry.getExtensionPoint(EXTENSION_SCM_HANDLERS_UI);
        if (scmHandlersUiExtensionPoint != null) {
            IExtension[] scmHandlersUiExtensions;
            IExtension[] iExtensionArray = scmHandlersUiExtensions = scmHandlersUiExtensionPoint.getExtensions();
            int n = scmHandlersUiExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_SCM_HANDLER_UI)) {
                        try {
                            scmHandlerUis.add((ScmHandlerUi)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return scmHandlerUis;
    }
}

