/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Enumeration;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.MultipartFormDataParserTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.PublishedItemsElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.MultipleFormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;

public abstract class PublishAction
extends UDDIPropertiesFormAction {
    protected String subQueryKey_ = null;
    protected boolean subQueryInitiated_ = false;
    protected String newSubQuery_;
    protected boolean isSubQueryGet_ = false;
    protected String newSubQueryItem_;
    protected RegistryNode regNode_ = this.getRegistryNode();

    public PublishAction(Controller controller) {
        super(controller);
    }

    protected abstract boolean processOthers(MultipartFormDataParser var1, FormToolPropertiesInterface var2) throws MultipartFormDataException;

    protected final boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        boolean validateAuthentication;
        this.propertyTable_.put("multipartFormDataParser", parser);
        this.newSubQuery_ = parser.getParameter("newSubQueryInitiated");
        String isSubQueryGetString = parser.getParameter("subQueryGet");
        this.newSubQueryItem_ = parser.getParameter("newSubQueryQueryItem");
        this.subQueryKey_ = parser.getParameter("subQueryKey");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        FormTool formTool = this.getSelectedFormTool();
        FormToolPropertiesInterface formToolPI = ((MultipleFormToolPropertiesInterface)((Object)formTool)).getFormToolProperties(this.subQueryKey_);
        formToolPI.clearErrors();
        this.subQueryInitiated_ = this.newSubQuery_ != null && this.newSubQuery_.length() > 0;
        if (isSubQueryGetString != null) {
            this.isSubQueryGet_ = Boolean.valueOf(isSubQueryGetString);
        }
        if (!this.processOthers(parser, formToolPI) && !this.subQueryInitiated_) {
            inputsValid = false;
        }
        int i = 0;
        while (i < this.removedProperties_.size()) {
            formToolPI.removeProperty(this.removedProperties_.elementAt(i));
            ++i;
        }
        formToolPI.updatePropertyTable(this.propertyTable_);
        String publishURL = parser.getParameter("advancedPublishURL");
        String userId = parser.getParameter("advancedUserId");
        String password = parser.getParameter("advancedPassword");
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        boolean bl = validateAuthentication = !regElement.isLoggedIn();
        if (publishURL != null) {
            this.propertyTable_.put("advancedPublishURL", publishURL);
            formTool.setProperty("advancedPublishURL", publishURL);
        }
        if (!this.subQueryInitiated_ && validateAuthentication && !Validator.validateString(publishURL)) {
            inputsValid = false;
            formTool.flagError("advancedPublishURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_PUBLISH_URL"));
        }
        if (userId != null) {
            this.propertyTable_.put("advancedUserId", userId);
            formTool.setProperty("advancedUserId", userId);
        }
        if (!this.subQueryInitiated_ && validateAuthentication && !Validator.validateString(userId)) {
            inputsValid = false;
            formTool.flagError("advancedUserId");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USERID"));
        }
        if (password != null) {
            this.propertyTable_.put("advancedPassword", password);
            formTool.setProperty("advancedPassword", password);
        }
        return inputsValid;
    }

    protected final void addPublishedItemNode(BusinessEntity be, RegistryElement regElement) {
        BusinessElement beElement = new BusinessElement(be, regElement.getModel());
        PublishedItemsElement publishedBusinessesElement = regElement.getPublishedBusinessesElement();
        Enumeration e = publishedBusinessesElement.getItems();
        while (e.hasMoreElements()) {
            BusinessElement element = (BusinessElement)((Object)e.nextElement());
            BusinessEntity elementBE = element.getBusinessEntity();
            if (!elementBE.getBusinessKey().equals(be.getBusinessKey())) continue;
            element.disconnectAll();
            break;
        }
        this.connectElements(publishedBusinessesElement, beElement);
    }

    protected final void addPublishedItemNode(BusinessService bs, RegistryElement regElement) {
        ServiceElement sElement = new ServiceElement(bs, regElement.getModel());
        PublishedItemsElement publishedServicesElement = regElement.getPublishedServicesElement();
        Enumeration e = publishedServicesElement.getItems();
        while (e.hasMoreElements()) {
            ServiceElement element = (ServiceElement)((Object)e.nextElement());
            BusinessService elementBS = element.getBusinessService();
            if (!elementBS.getServiceKey().equals(bs.getServiceKey())) continue;
            element.disconnectAll();
            break;
        }
        this.connectElements(publishedServicesElement, sElement);
    }

    protected final void addPublishedItemNode(TModel tModel, RegistryElement regElement) {
        ServiceInterfaceElement siElement = new ServiceInterfaceElement(tModel, regElement.getModel());
        PublishedItemsElement publishedServiceInterfacesElement = regElement.getPublishedServiceInterfacesElement();
        Enumeration e = publishedServiceInterfacesElement.getItems();
        while (e.hasMoreElements()) {
            ServiceInterfaceElement element = (ServiceInterfaceElement)((Object)e.nextElement());
            TModel elementTModel = element.getTModel();
            if (!tModel.getTModelKey().equals(elementTModel.getTModelKey())) continue;
            element.disconnectAll();
            break;
        }
        this.connectElements(publishedServiceInterfacesElement, siElement);
    }

    private final void connectElements(PublishedItemsElement publishedItemsElement, TreeElement itemElement) {
        publishedItemsElement.connect((Element)itemElement, "publishedItems", "owner");
        int newNodeId = this.regNode_.getChildNode(publishedItemsElement).getChildNode(itemElement).getNodeId();
        NodeManager nodeManager = this.regNode_.getNodeManager();
        nodeManager.setSelectedNodeId(newNodeId);
        Node newNode = nodeManager.getSelectedNode();
        ToolManager toolManager = newNode.getToolManager();
        Tool selectedTool = toolManager.getSelectedTool();
        this.addToHistory(0, selectedTool.getSelectToolActionHref(true));
    }

    public final boolean isSubQueryInitiated() {
        return this.subQueryInitiated_;
    }

    public final boolean isSubQueryGet() {
        return this.isSubQueryGet_;
    }

    public final String getSubQueryKey() {
        return this.subQueryKey_;
    }

    public final String getNewSubQuery() {
        return this.newSubQuery_;
    }

    public final String getNewSubQueryItem() {
        return this.newSubQueryItem_;
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new MultipartFormDataParserTransformer(this.controller_);
        return transformers;
    }
}

